///////////////////////////
//	File: CBackground.cpp
//	Author:	Eric Green
//	Purpose: Background class function definitions
#include "CBackground.h"
#include "CSGD_TextureManager.h"
#pragma warning(disable:4244)
#define RAND_FLOAT(min,max) (((rand()/(float)RAND_MAX)*((max)-(min)))+(min))


CBackground::CBackground(void)
{	
	SetHealth(3);
}

CBackground::~CBackground(void)
{
}

void CBackground::Render()
{
	DWORD color;
	switch(GetState())
	{
	case 0:
		color = D3DCOLOR_ARGB(255,255,255,255);
		break;
	case 1:
		color = D3DCOLOR_ARGB(128,255,255,255);
		break;
	case 2:
		color = D3DCOLOR_ARGB(64,255,255,255);
		break;
	case 3:
		color = D3DCOLOR_ARGB(32,255,255,255);
		break;
	}


	RECT offset;
	offset.top = GetYPos();
	offset.left = GetXPos();
	offset.right = offset.left + GetWidth();
	offset.bottom = offset.top + 600;

	CSGD_TextureManager::GetInstance()->Draw(GetID(), 0,0,1,1,&offset,0,0,0,color);
}

void CBackground::Update()
{
	CBase::Update();

	//WRITE BG SWITCHER LATER
	if(GetYPos() <= -600)
	{
		/*int bg = RAND_FLOAT(1,3);
		switch(bg)
		{
		case 1:
			SetID(CSGD_TextureManager::GetInstance()->LoadTexture("ErG_ParalaxBig.png"));
			break;
		case 2:
			SetID(CSGD_TextureManager::GetInstance()->LoadTexture("ErG_ParalaxBig2.png"));
			break;
		case 3:
			SetID(CSGD_TextureManager::GetInstance()->LoadTexture("ErG_ParalaxBig3.png"));
			break;
		}*/

		SetYPos(2400);
	}
}