///////////////////////////
//	File: CBase.cpp
//	Author:	Eric Green
//	Purpose: Base class function definitions
#include "CBase.h"
#include "CSGD_Direct3D.h"
#include "CSGD_TextureManager.h"
#include "CSGD_DirectSound.h"
#include "CSGD_WaveManager.h"
#include "CSGD_DirectInput.h"
#include "CSGD_Flags.h"
CBase::CBase(void)
{
	SetPosition(0,0);
	
	SetVelocity(1,1);
	
	SetID(0);

	SetHealth(3);
}

CBase::~CBase(void)
{
}

bool CBase::GetOwner()
{
	return m_bEnemy;
}
	
void CBase::SetOwner(bool val)
{
	m_bEnemy = val;
}


float CBase::GetXPos()
{
	return m_fLawlXPos;
}
float CBase::GetYPos()
{
	return m_fLawlYPos;
}
float CBase::GetXVel()
{
	return m_fLawlXVel;
}
float CBase::GetYVel()
{
	return m_fLawlYVel;
}
int CBase::GetID()
{
	return m_iLawlImageID;
}

float CBase::GetWidth()
{
	return m_fLawlWidth;
}

float CBase::GetHeight()
{
	return m_fLawlHeight;
}

RECT CBase::GetRect()
{
	RECT rBound;
	rBound.left = (LONG)GetXPos();
	rBound.top = (LONG)GetYPos();
	rBound.right = (LONG)rBound.left + (LONG)GetWidth();
	rBound.bottom = (LONG)rBound.top + (LONG)GetHeight();
	
	return rBound;
}

string CBase::GetName()
{
	return m_szName;
}

int CBase::GetType()
{
	return m_nType;
}

void CBase::SetPosition(float xval, float yval)
{
	m_fLawlXPos = xval;
	m_fLawlYPos = yval;
}
void CBase::SetXPos(float val)
{
	m_fLawlXPos = val;	
}
void CBase::SetYPos(float val)
{
	m_fLawlYPos = val;
}
void CBase::SetVelocity(float xval, float yval)
{
	m_fLawlXVel = xval;
	m_fLawlYVel = yval;
}
void CBase::SetXVel(float val)
{
	m_fLawlXVel = val;
}
void CBase::SetYVel(float val)
{
	m_fLawlYVel = val;
}
void CBase::SetID(int ID)
{
	m_iLawlImageID = ID;
}
void CBase::SetWidth(float val)
{
	m_fLawlWidth = val;
}
void CBase::SetHeight(float val)
{
	m_fLawlHeight = val;
}

void CBase::SetBounds(float wval, float hval)
{
	m_fLawlWidth = wval;
	m_fLawlHeight = hval;
}

void CBase::SetName(string name)
{
	m_szName = name;
}
void CBase::SetType(int type)
{
	m_nType = type;
}


void CBase::Update()
{
	float x = GetXPos();
	float y = GetYPos();
	SetPosition(x + GetXVel(),y + GetYVel());
}


void CBase::Render()
{
	int Health;
	Health = 85 * GetHealth();
	DWORD color = D3DCOLOR_ARGB(255,255,Health,Health);

	CSGD_TextureManager::GetInstance()->Draw(GetID(), (int)GetXPos(),(int)GetYPos(),1,1,0,0,0,0,color);

}

bool CBase::CheckCollision(CBase* obj)
{
	RECT rTemp;
	if(IntersectRect(&rTemp,&GetRect(), &obj->GetRect()))
		return true;
	else
		return false;
}

int CBase::GetHealth()
{
	return m_iHealth;
}
DWORD CBase::GetLastFire()
{
	return m_dwLastFire;
}
DWORD CBase::GetBirth()
{
	return m_dwBornOnDate;
}

int CBase::GetLifeExpect()
{
	return m_nLifeExpect;
}

DWORD CBase::GetTracking()
{
	return m_dwLastTrack;
}

	
void CBase::SetHealth(int val)
{
	m_iHealth = val;
}

int CBase::GetState()
{
	return m_nState;
}

void CBase::SetState(int val)
{
	m_nState = val;
}

void CBase::SetLastFire(DWORD val)
{
	m_dwLastFire = val;
}

void CBase::SetBirth(DWORD val)
{
	m_dwBornOnDate = val;
}

void CBase::SetLifeExpect(int val)
{
	m_nLifeExpect = val;
}

void CBase::SetTracking(DWORD val)
{
	m_dwLastTrack = val;
}
