///////////////////////////////
//File:Base.h
//Author:Eric Green
//Purpose:Contains the base class for the Game project
#pragma once

#include "IBaseInterface.h"
#include "IListener.h"
#include <windows.h>
#include <string>
using std::string;

class CBase : public IBaseInterface, public IListener
{
private:
	//unsigned int m_unRefCount;
	float m_fLawlXPos, m_fLawlYPos;
	float m_fLawlXVel, m_fLawlYVel;
	float m_fLawlWidth, m_fLawlHeight;
	int m_iLawlImageID;
	string m_szName;
	int m_nType;
	int m_iHealth;
	bool m_bEnemy;
	int m_nLifeExpect;
	DWORD m_dwBornOnDate;
	DWORD m_dwLastFire;
	DWORD m_dwLastTrack;
	int m_nState;


public:
	enum eType{OBJECT_PLAYER=0, OBJECT_BULLET, OBJECT_ENEMY, OBJECT_SHIELD,
		OBJECT_MINIBOSS, OBJECT_BOSS, OBJECT_PICKUP, OBJECT_MISSILE};
	enum eOwner {OWNER_PLAYER=0, OWNER_ENEMY};
	CBase(void);
	virtual ~CBase(void);
	//////////////////////////
	//Function:Update
	//Purpose: To update the objects information
	virtual void Update();
	//////////////////////////
	//Function:Render
	//Purpose: To render the object
	virtual void Render();
	///////
	//Function:GetHealth
	//Purpose:Return the value of health
	int GetHealth();
	///////
	//Function:SetHealth
	//Purpose:Set the value of the sheilds health
	void SetHealth(int val);
	
	////////
	//Function:GetEnemyStatus
	//Purpose:return information on enemy status
	bool GetOwner();
	////////
	//Function:SetEnemyStatus
	//Purpose:set enemy status information
	void SetOwner(bool val);

	/////////////////////////
	//Function: Accessors
	//Purpose: Returns specified type
	float GetXPos();
	float GetYPos();
	float GetXVel();
	float GetYVel();
	int	GetID();
	float GetWidth();
	float GetHeight();
	RECT GetRect();
	string GetName();
	int GetType();
	int	GetState();
	DWORD GetLastFire();
	DWORD GetBirth();
	int GetLifeExpect();
	DWORD GetTracking();
	/////////////////////////
	//Function: Modifier
	//Purpose: Modify specified type
	void SetPosition(float xval, float yval);
	void SetXPos(float val);
	void SetYPos(float val);
	void SetVelocity(float xval, float yval);
	void SetXVel(float val);
	void SetYVel(float val);
	void SetID(int ID);
	void SetWidth(float val);
	void SetHeight(float val);
	void SetBounds(float wval, float hval);
	void SetName(string name);
	void SetType(int type);
	void SetLastFire(DWORD val);
	void SetState(int val);
	void SetBirth(DWORD val);
	void SetLifeExpect(int val);
	void SetTracking(DWORD val);
	
	////////
	//Function:CheckCollision
	//Purpose: to check for object collision
	bool CheckCollision(CBase * obj);

	virtual void HandleEvent(CEvent *pEvent) {}

	

	void AddRef() { m_unRefCount++; }

	void Release()
	{
		m_unRefCount--;
		if(m_unRefCount == 0)
			delete this;
	}
};
