///////////////////////////
//	File: CBoss.cpp
//	Author:	Eric Green
//	Purpose: Enemy class function definitions
#include "CBoss.h"
#include "CWorld.h"
#include "CSGD_Dispatcher.h"
#include "CSGD_DirectInput.h"
#include "CSGD_TextureManager.h"

#define SCREEN_WIDTH 800
#define SCREEN_HEIGHT 600
#define VEL 2

void CBoss::HandleEvent(CEvent *pEvent)
{
	if(!pEvent) return;
	
}

void CBoss::Update()
{
	
	if(CSGD_DirectInput::GetInstance()->GetBufferedKey(DIK_T))
		SetVelocity(0,0);
	if(GetYPos() < -200)
		SetVelocity(0,GetYVel()+1);
	if(GetYPos() > 150)
		SetVelocity(0,0);
	//SetStateBasedonTime

	static int TimeState = GetBirth();
	int TBS = 5000;
	if((GetTickCount() - TimeState) > TBS)
	{
		if(GetState() < 5)
			SetState(GetState()+1);
		else
			SetState(1);
		TimeState = GetTickCount();
	}

	
	
	CBase::Update();
}
CBoss::CBoss(void)
{
	SetPosition(0,0);
	SetVelocity(0,.2f);
	SetHealth(3);
}

CBoss::~CBoss(void)
{
}

void CBoss::Render()
{
	/*int Health;
	Health = 85 * GetHealth();
	DWORD color = D3DCOLOR_ARGB(255,255,Health,Health);*/

	CSGD_TextureManager::GetInstance()->Draw(GetID(),(int)GetXPos(),(int)GetYPos(),1,1);
	/*else
		CSGD_TextureManager::GetInstance()->Draw(GetID(), (int)GetXPos()+GetWidth(),(int)GetYPos()+GetHeight(),-1,-1,0,0,0,0,color);*/
}