///////////////////////////
//	File: CEnemy.cpp
//	Author:	Eric Green
//	Purpose: Enemy class function definitions
#include "CEnemy.h"
#include "CWorld.h"
#include "CSGD_Dispatcher.h"
#include "CSGD_DirectInput.h"
#include "CSGD_TextureManager.h"
#include "CSGD_MessageSystem.h"

#define SCREEN_WIDTH 800
#define SCREEN_HEIGHT 600
#define VEL 2

void CEnemy::HandleEvent(CEvent *pEvent)
{
	if(!pEvent) return;
	//handle event
	int velocity =0;

	if(pEvent->GetEventID() == "Enemy.Move.Left")
	{		
		SetXVel(GetXVel()-VEL);
	}
	if(pEvent->GetEventID() == "Enemy.Move.Right")
	{
		SetXVel(GetXVel()+VEL);
	}
	
	if(pEvent->GetEventID() == "Enemy.Move.Stop")
	{
		SetXVel(0);
		SetYVel(0);
	}
}

void CEnemy::Update()
{
	

	CWorld *m_pWorld = CWorld::GetInstance();
	int velocity = 2;
	if(GetXPos() >= SCREEN_WIDTH-GetWidth())
	{		
		CSGD_Dispatcher::GetInstance()->SendEvent("Enemy.Move.Left", &velocity);
	}
	if(GetXPos() <= 0)
	{
		CSGD_Dispatcher::GetInstance()->SendEvent("Enemy.Move.Right", &velocity);
	}
	
	if(CSGD_DirectInput::GetInstance()->GetBufferedKey(DIK_T))
		CSGD_Dispatcher::GetInstance()->SendEvent("Enemy.Move.Stop", &velocity);
	if(GetYPos() < -200)
		SetVelocity(0,GetYVel()+1);
	if(GetYPos() > SCREEN_HEIGHT+200)
		SetVelocity(0,(GetYVel()+1)*-1);
	
	CBase::Update();
}
CEnemy::CEnemy(void)
{
	SetPosition(0,0);
	SetVelocity(2,0);
	SetHealth(3);
}

CEnemy::~CEnemy(void)
{
}

void CEnemy::Render()
{
	int Health;
	Health = 85 * GetHealth();
	DWORD color = D3DCOLOR_ARGB(255,255,Health,Health);

	if(GetYVel() > 0)
		CSGD_TextureManager::GetInstance()->Draw(GetID(), (int)GetXPos(),(int)GetYPos(),1,1,0,0,0,0,color);
	else
		CSGD_TextureManager::GetInstance()->Draw(GetID(), (int)GetXPos()+GetWidth(),(int)GetYPos()+GetHeight(),-1,-1,0,0,0,0,color);



}
