///////////////////////////
//	File: CEvents.h
//	Author:	Eric Green
//	Purpose: contains our event information

#pragma once
#include <string>
using std::string;

typedef string EVENTID;

class CEvent
{
private:
	EVENTID m_EventID;	//ID of the event
	void*	m_pParam;	//some data that is particular to this event.


public:
	CEvent() { m_pParam = 0; }
	~CEvent() {}

	void SetEventParams(EVENTID eventID, void *pParam = 0)
	{
		m_EventID = eventID;
		m_pParam = pParam;
	}

	//modifiers
	inline void SetEventID(EVENTID id) { m_EventID = id; }
	inline void SetEventsparam(void *pParam) { m_pParam = pParam;}

	inline EVENTID GetEventID() { return m_EventID;}
	inline void *GetParam()		{ return m_pParam;}

};