///////////////////////////
//	File: CGameClass.cpp
//	Author:	Eric Green
//	Purpose: Contains all CGameClass function definitions
#pragma warning(disable:4482)
#pragma warning(disable:4995)
#pragma warning(disable:4244)
#pragma warning(disable:4018)
#include "CGameClass.h"


#include <windows.h>

#define SCREEN_WIDTH	800
#define SCREEN_HEIGHT	600
#define VEL				3
#define RAND_FLOAT(min,max) (((rand()/(float)RAND_MAX)*((max)-(min)))+(min))
#define RR(low, high)	((rand() % (high - low)) + low)
#define MAX_PARTICLES 100



//initialize the static variable member of the class.
CGameClass * CGameClass::m_pInstance = 0;

///////
//Function:GameMsgProc
//purpose: Processes messages sent out by the game
void GameMsgProc(CBaseMessage *pMsg)
{
	switch (pMsg->GetMessageID())
	{
		//Message To check for
	case CWorld::eGAME_MESSAGES::eGM_COLLISION:
		{
			CPlayer * Ship =  (CPlayer*)((CCreateBulletMessage*)pMsg)->GetParam();
			//What to do when message is recieved
			
						//if health = 0 game over
			if(!CWorld::GetInstance()->GetGodMode())
				Ship->SetHealth(Ship->GetHealth()-1);
						if(Ship->GetHealth() <= 0)
						{
							
								if(CWorld::GetInstance()->GetLives() > 0)
								{
									Ship->SetPosition(SCREEN_WIDTH>>1, SCREEN_HEIGHT-100);
									Ship->SetHealth(3);
									CWorld::GetInstance()->SetLives(CWorld::GetInstance()->GetLives()-1);
								}
								else
								{
									CGameClass::GetInstance()->GameReset();
									CSGD_WaveManager::GetInstance()->Play(CWorld::GetInstance()->GetGameOverSound());
									CWorld::GetInstance()->SetEndCondition(CWorld::eEnd::END_LOSE);
									CWorld::GetInstance()->SetMenuState(CWorld::eMState::MENU_ON);
								}
							break;
						}
			break;
		}
		break;
	case CWorld::eGAME_MESSAGES::eGM_CREATE_ENEMY:
		{
			//What to do when message is recieved
			CEnemy* m_pEnemy;
			m_pEnemy = (CEnemy*)CSGD_ObjectFactory<string, CBase>::GetInstance()->CreateObject("CEnemy");			
			char buffer[128];
			m_pEnemy->SetID(CSGD_TextureManager::GetInstance()->LoadTexture("ErG_TestRaider.png", D3DCOLOR_XRGB(0,0,0)));
			m_pEnemy->SetBounds(32,64);
			wsprintf(buffer,"Enemy%d",CWorld::GetInstance()->GetEnemyCount());
			m_pEnemy->SetName(buffer);
			m_pEnemy->SetType(CBase::eType::OBJECT_ENEMY);
			m_pEnemy->SetPosition(RAND_FLOAT(100,700),-200);
			m_pEnemy->SetVelocity(0,1);
			m_pEnemy->SetHealth(CWorld::GetInstance()->GetDifficulty());
			m_pEnemy->SetLastFire(GetTickCount());
			m_pEnemy->SetBirth(GetTickCount());
			m_pEnemy->SetLifeExpect(15000);
			CSGD_ObjectManager::GetInstance()->AddObject(m_pEnemy->GetName(), m_pEnemy);

			CSGD_Dispatcher::GetInstance()->RegisterClient("Enemy.Move.Left", m_pEnemy);
			CSGD_Dispatcher::GetInstance()->RegisterClient("Enemy.Move.Right", m_pEnemy);
			CSGD_Dispatcher::GetInstance()->RegisterClient("Enemy.Move.Stop", m_pEnemy);
			

			CWorld::GetInstance()->SetEnemyCount(CWorld::GetInstance()->GetEnemyCount()+1);
			m_pEnemy->Release();	
		}
		break;
	case CWorld::eGAME_MESSAGES::eGM_CREATE_MINIBOSS:
		{
			CMiniBoss* m_pMiniBoss;
			static int mbosscount = 0;
			m_pMiniBoss = (CMiniBoss*)CSGD_ObjectFactory<string, CBase>::GetInstance()->CreateObject("CMiniBoss");			
			char buffer[128];
			m_pMiniBoss->SetID(CSGD_TextureManager::GetInstance()->LoadTexture("ErG_GameBasestar.png", D3DCOLOR_XRGB(0,0,0)));
			m_pMiniBoss->SetBounds(64,128);
			wsprintf(buffer,"MiniBoss%d",mbosscount);
			m_pMiniBoss->SetName(buffer);
			m_pMiniBoss->SetType(CBase::eType::OBJECT_MINIBOSS);
			m_pMiniBoss->SetPosition(RAND_FLOAT(200,664),-200);
			m_pMiniBoss->SetVelocity(0,.3f);
			m_pMiniBoss->SetHealth(CWorld::GetInstance()->GetDifficulty());
			m_pMiniBoss->SetState(1);
			m_pMiniBoss->SetHealth(9);
			m_pMiniBoss->SetLastFire(GetTickCount());
			m_pMiniBoss->SetBirth(GetTickCount());
			m_pMiniBoss->SetLifeExpect(45000);
			CSGD_ObjectManager::GetInstance()->AddObject(m_pMiniBoss->GetName(), m_pMiniBoss);

			
			CSGD_Dispatcher::GetInstance()->RegisterClient("MiniBoss.Move.Stop", m_pMiniBoss);
			m_pMiniBoss->Release();
			mbosscount++;
		}
		break;
	case CWorld::eGAME_MESSAGES::eGM_CREATE_BOSS:
		{
			CBoss* m_pBoss;
			static int bosscount = 0;
			m_pBoss = (CBoss*)CSGD_ObjectFactory<string, CBase>::GetInstance()->CreateObject("CBoss");			
			char buffer[128];
			m_pBoss->SetID(CSGD_TextureManager::GetInstance()->LoadTexture("ErG_GameBasestar.png", D3DCOLOR_XRGB(0,0,0)));
			m_pBoss->SetBounds(64,128);
			wsprintf(buffer,"Boss%d",bosscount);
			m_pBoss->SetName(buffer);
			m_pBoss->SetType(CBase::eType::OBJECT_BOSS);
			m_pBoss->SetPosition((SCREEN_WIDTH>>1)-32,100);
			m_pBoss->SetVelocity(0,0);
			m_pBoss->SetHealth(CWorld::GetInstance()->GetDifficulty());
			m_pBoss->SetState(1);
			m_pBoss->SetHealth(60);
			m_pBoss->SetLastFire(GetTickCount());
			m_pBoss->SetBirth(GetTickCount());
			m_pBoss->SetLifeExpect(180000);
			CSGD_ObjectManager::GetInstance()->AddObject(m_pBoss->GetName(), m_pBoss);

			
			CSGD_Dispatcher::GetInstance()->RegisterClient("Boss.Move.Stop", m_pBoss);
			m_pBoss->Release();
			bosscount++;
		}
		break;
	case CWorld::eGAME_MESSAGES::eGM_DROP_PICKUP:
		{
			CPickup* m_pPickup;
			static int pickupcount = 0;
			CEnemy * Ship =  (CEnemy*)((CCreateBulletMessage*)pMsg)->GetParam();
			m_pPickup = (CPickup*)CSGD_ObjectFactory<string, CBase>::GetInstance()->CreateObject("CPickup");			
			char buffer[128];
			m_pPickup->SetID(CSGD_TextureManager::GetInstance()->LoadTexture("ErG_BsPickup.png", D3DCOLOR_XRGB(0,0,0)));
			m_pPickup->SetBounds(32,32);
			wsprintf(buffer,"Pickup%d",pickupcount);
			m_pPickup->SetName(buffer);
			m_pPickup->SetType(CBase::eType::OBJECT_PICKUP);
			m_pPickup->SetPosition(Ship->GetXPos()+(Ship->GetWidth()/2),Ship->GetYPos()+(Ship->GetHeight()/2));
			m_pPickup->SetVelocity(0,2);
			m_pPickup->SetHealth(CWorld::GetInstance()->GetDifficulty());
			m_pPickup->SetHealth(3);
			CSGD_ObjectManager::GetInstance()->AddObject(m_pPickup->GetName(), m_pPickup);

			
			m_pPickup->Release();
			pickupcount++;
		}
		break;
	case CWorld::eGAME_MESSAGES::eGM_PLAYER_FIRE:
		{
			static unsigned int bulletcounter = 0;
			static unsigned int crazybullet = 1;
			char buffer[128];
			//play sound
			CSGD_WaveManager::GetInstance()->Play(CWorld::GetInstance()->GetShotSound());
			CPlayer * Ship =  (CPlayer*)((CCreateBulletMessage*)pMsg)->GetParam();
			//init the bullet
			CBullet* m_pBullet;
			for(int i = 0; i < CWorld::GetInstance()->GetWeaponLevel(); i++)
			{
				m_pBullet = (CBullet*)CSGD_ObjectFactory<string, CBase>::GetInstance()->CreateObject("CBullet");
				switch(i)
				{
				case 0:
					m_pBullet->SetPosition(Ship->GetXPos()+6,Ship->GetYPos()+4);
					m_pBullet->SetVelocity(0.0f,-5.0f);	
					break;
				case 1:
					m_pBullet->SetPosition(Ship->GetXPos()+18,Ship->GetYPos()+4);
					m_pBullet->SetVelocity(0.0f,-5.0f);	
					break;
				case 2:
					m_pBullet->SetPosition(Ship->GetXPos()+12,Ship->GetYPos());
					m_pBullet->SetVelocity(0.0f,-5.0f);	
					break;
				case 3:
					m_pBullet->SetPosition(Ship->GetXPos()+12,Ship->GetYPos()+2);
					if(crazybullet % 2)
						m_pBullet->SetVelocity(2.0f,-5.0f);	
					else
						m_pBullet->SetVelocity(-2.0f,-5.0f);
					crazybullet++;


					break;
				}	
				if(CWorld::GetInstance()->GetWeaponLevel() <= 3)
				{
					m_pBullet->SetID(CSGD_TextureManager::GetInstance()->LoadTexture("ErG_BsBullet.png", D3DCOLOR_XRGB(0,0,0)));
					m_pBullet->SetHealth(4-CWorld::GetInstance()->GetWeaponLevel());
				}
				else
				{
					m_pBullet->SetID(CSGD_TextureManager::GetInstance()->LoadTexture("ErG_CadEgg.png", D3DCOLOR_XRGB(0,0,0)));
					m_pBullet->SetHealth(3);
				}
				m_pBullet->SetBounds(4,8);
				m_pBullet->SetOwner(CBullet::eOwner::OWNER_PLAYER);
				
				
				//add to object manager
				wsprintf(buffer,"Bullet%d", bulletcounter);
				m_pBullet->SetName(buffer);
				m_pBullet->SetType(CBullet::eType::OBJECT_BULLET);
				CSGD_Dispatcher::GetInstance()->RegisterClient("collision",m_pBullet);
				CSGD_ObjectManager::GetInstance()->AddObject(m_pBullet->GetName(), m_pBullet);
				//incriment bullet counter
				bulletcounter++;
				//release unwanted garbage
				m_pBullet->Release();
			}
		}
		break;
	case CWorld::eGAME_MESSAGES::eGM_ENEMY_FIRE:
		{
			static unsigned int ebulletcounter = 0;
			char ebuffer[128];
			//play sound
			//CSGD_WaveManager::GetInstance()->Play(CWorld::GetInstance()->GetShotSound());
			CEnemy * Ship =  (CEnemy*)((CCreateBulletMessage*)pMsg)->GetParam();
			//init the bullet
			CBullet* m_pBullet;
			for(int i = 0; i < 2;i++)
			{
				m_pBullet = (CBullet*)CSGD_ObjectFactory<string, CBase>::GetInstance()->CreateObject("CBullet");
				m_pBullet->SetPosition(Ship->GetXPos()+(8+(i*8)),Ship->GetYPos()-4);
				m_pBullet->SetVelocity(0.0f,5.0f);	
				m_pBullet->SetID(CSGD_TextureManager::GetInstance()->LoadTexture("SGD_bullet.bmp", D3DCOLOR_XRGB(0,0,0)));
				m_pBullet->SetBounds(8,8);
				m_pBullet->SetOwner(CBullet::eOwner::OWNER_ENEMY);
				//add to object manager
				wsprintf(ebuffer,"EBullet%d", ebulletcounter);
				m_pBullet->SetName(ebuffer);
				m_pBullet->SetType(CBullet::eType::OBJECT_BULLET);
				CSGD_Dispatcher::GetInstance()->RegisterClient("collision",m_pBullet);
				CSGD_ObjectManager::GetInstance()->AddObject(m_pBullet->GetName(), m_pBullet);
				//incriment bullet counter
				ebulletcounter++;
				//release unwanted garbage
				m_pBullet->Release();
			}
			//what to do when message is recieved
		}
		break;
	case CWorld::eGAME_MESSAGES::eGM_MBOSS_FIRE:
		{
			static unsigned int mbbulletcounter = 0;
			char ebuffer[128];
			//play sound
			//CSGD_WaveManager::GetInstance()->Play(CWorld::GetInstance()->GetShotSound());
			CEnemy * Ship =  (CEnemy*)((CCreateBulletMessage*)pMsg)->GetParam();
			//init the bullet
			CBullet* m_pBullet;
			for(int i = 0; i < 3;i++)
			{
				m_pBullet = (CBullet*)CSGD_ObjectFactory<string, CBase>::GetInstance()->CreateObject("CBullet");
				m_pBullet->SetPosition(Ship->GetXPos()+(8+(i*8)),Ship->GetYPos()-4);
				switch(i)
				{
				case 0:
					m_pBullet->SetVelocity(0.0f,2.0f);
				break;
				case 1:
					m_pBullet->SetVelocity(2.0f,2.0f);
				break;
				case 2:
					m_pBullet->SetVelocity(-2.0f,2.0f);
				break;
				}


				m_pBullet->SetID(CSGD_TextureManager::GetInstance()->LoadTexture("ErG_MiniBossShot.png", D3DCOLOR_XRGB(0,0,0)));
				m_pBullet->SetBounds(8,8);
				m_pBullet->SetOwner(CBullet::eOwner::OWNER_ENEMY);
				//add to object manager
				wsprintf(ebuffer,"MBBullet%d", mbbulletcounter);
				m_pBullet->SetName(ebuffer);
				m_pBullet->SetType(CBullet::eType::OBJECT_BULLET);
				CSGD_Dispatcher::GetInstance()->RegisterClient("collision",m_pBullet);
				CSGD_ObjectManager::GetInstance()->AddObject(m_pBullet->GetName(), m_pBullet);
				//incriment bullet counter
				mbbulletcounter++;
				//release unwanted garbage
				m_pBullet->Release();
			}
		}
		break;
	case CWorld::eGAME_MESSAGES::eGM_BOSS_FIRE:
		{
			static unsigned int bbulletcounter = 0;
			char ebuffer[128];
			//play sound
			//CSGD_WaveManager::GetInstance()->Play(CWorld::GetInstance()->GetShotSound());
			CEnemy * Ship =  (CEnemy*)((CCreateBulletMessage*)pMsg)->GetParam();
			//init the bullet
			CBullet* m_pBullet;
			for(int i = 0; i < 5;i++)
			{
				m_pBullet = (CBullet*)CSGD_ObjectFactory<string, CBase>::GetInstance()->CreateObject("CBullet");
				m_pBullet->SetPosition(Ship->GetXPos()+(8+(i*8)),Ship->GetYPos()-4);
				switch(i)
				{
				case 0:
					m_pBullet->SetVelocity(0.0f,3.0f);
					break;
				case 1:
					m_pBullet->SetVelocity(3.0f,3.0f);
					break;
				case 2:
					m_pBullet->SetVelocity(-3.0f,3.0f);
					break;
				case 3:
					m_pBullet->SetVelocity(-1.0f,3.0f);
					break;
				case 4:
					m_pBullet->SetVelocity(1.0f,3.0f);
					break;
				}


				m_pBullet->SetID(CSGD_TextureManager::GetInstance()->LoadTexture("ErG_MiniBossShot.png", D3DCOLOR_XRGB(0,0,0)));
				m_pBullet->SetBounds(8,8);
				m_pBullet->SetOwner(CBullet::eOwner::OWNER_ENEMY);
				//add to object manager
				wsprintf(ebuffer,"BBullet%d", bbulletcounter);
				m_pBullet->SetName(ebuffer);
				m_pBullet->SetType(CBullet::eType::OBJECT_BULLET);
				CSGD_Dispatcher::GetInstance()->RegisterClient("collision",m_pBullet);
				CSGD_ObjectManager::GetInstance()->AddObject(m_pBullet->GetName(), m_pBullet);
				//incriment bullet counter
				bbulletcounter++;
				//release unwanted garbage
				m_pBullet->Release();
			}

		}
		break;
	case CWorld::eGAME_MESSAGES::eGM_MISSLE_FIRE:
		{
			static unsigned int missilecounter = 0;
			char ebuffer[128];
			//play sound
			//CSGD_WaveManager::GetInstance()->Play(CWorld::GetInstance()->GetShotSound());
			CEnemy * Ship =  (CEnemy*)((CCreateBulletMessage*)pMsg)->GetParam();
			//init the bullet
			CMissile* m_pMissile;
			m_pMissile = (CMissile*)CSGD_ObjectFactory<string, CBase>::GetInstance()->CreateObject("CMissile");
			m_pMissile->SetPosition(Ship->GetXPos()+(Ship->GetWidth()/2),Ship->GetYPos()-4);
			m_pMissile->SetVelocity(0.0f,2.0f);	
			m_pMissile->SetID(CSGD_TextureManager::GetInstance()->LoadTexture("ErG_HomingShot.png", D3DCOLOR_XRGB(0,0,0)));
			m_pMissile->SetBounds(16,16);
			m_pMissile->SetOwner(CBullet::eOwner::OWNER_ENEMY);
			//add to object manager
			wsprintf(ebuffer,"Missile%d", missilecounter);
			m_pMissile->SetName(ebuffer);
			m_pMissile->SetType(CMissile::eType::OBJECT_MISSILE);
			m_pMissile->SetBirth(GetTickCount());
			m_pMissile->SetTracking(GetTickCount());
			m_pMissile->SetLifeExpect(5000);
			CSGD_Dispatcher::GetInstance()->RegisterClient("collision",m_pMissile);
			CSGD_ObjectManager::GetInstance()->AddObject(m_pMissile->GetName(), m_pMissile);
			//incriment bullet counter
			missilecounter++;
			//release unwanted garbage
			m_pMissile->Release();
			
		}
		break;
	case CWorld::eGAME_MESSAGES::eGM_KILL_BULLET:
		{
			CBullet * bullet = (CBullet*)((CDestroyBulletMessage*)pMsg)->GetParam();

			CSGD_ObjectManager::GetInstance()->RemoveObject(bullet->GetName(), bullet);
		}
		break;
	case CWorld::eGAME_MESSAGES::eGM_MOVE:
		{
			int velocity =0;
			int dir = (int)((CMoveMessage*)pMsg)->GetDirection();
			if(dir == CWorld::eDirections::eDIR_LEFT)
			{
				velocity = -VEL;
				CSGD_Dispatcher::GetInstance()->SendEvent("Player.Move.Left", &velocity);
				break;
			}
			if(dir == CWorld::eDirections::eDIR_RIGHT)
			{
				velocity = VEL;
				CSGD_Dispatcher::GetInstance()->SendEvent("Player.Move.Right", &velocity);
				break;
			}
			if(dir == CWorld::eDirections::eDIR_UP)
			{
				velocity = -VEL;
				CSGD_Dispatcher::GetInstance()->SendEvent("Player.Move.Up", &velocity);
				break;
			}
			if(dir == CWorld::eDirections::eDIR_DOWN)
			{
				velocity = VEL;
				CSGD_Dispatcher::GetInstance()->SendEvent("Player.Move.Down", &velocity);
				break;
			}
			if(dir == CWorld::eDirections::eDIR_STOP)
			{
				velocity = 0;
				CSGD_Dispatcher::GetInstance()->SendEvent("Player.Move.Stop", &velocity);
				break;
			}
		}
		break;
		//CONTINUE INTEGRATION OF EVENT AND MESSAGE SYSTEMS. COME UP WITH MORE MSGS
		//MOVE ENUMS OVER TO CWORLD
		//TEST ADDED FUNCTIONALITY
		//GET THIS SHEET TO COMPILE
		//

		//insert more message handling here.
	}
}
CGameClass* CGameClass::GetInstance()
{
	//make sure one has not been created yet.
	if(!m_pInstance)
	{
		m_pInstance = new CGameClass;
	}

	//return the memory address of the isntance
	return m_pInstance;
}

//delete instance
void CGameClass::DeleteInstance()
{
	//test to see if memory is valid
	if(m_pInstance)
	{
		delete m_pInstance;
		m_pInstance = 0;
	}
}


CGameClass::CGameClass()
{
	m_pD3D = 0;
	m_pTM = 0;
	m_pDS = 0;
	m_pWM = 0;
	m_pDI = 0;
	m_pWorld = 0;
	m_pMM = 0;
	m_bWindowed = 1;

}

CGameClass::~CGameClass()
{}
bool CGameClass::GameInit(HWND hWnd, HINSTANCE hInstance, int nWidth, int nHeight, bool bWindowed)
{
	m_pD3D = CSGD_Direct3D::GetInstance();
	m_pTM = CSGD_TextureManager::GetInstance();
	m_pDS = CSGD_DirectSound::GetInstance();
	m_pWM = CSGD_WaveManager::GetInstance();
	m_pDI = CSGD_DirectInput::GetInstance();
	m_pOF = CSGD_ObjectFactory<string, CBase>::GetInstance();
	m_pOM = CSGD_ObjectManager::GetInstance();
	m_pWorld = CWorld::GetInstance();
	m_pMM = CSGD_MemoryManager::GetInstance();
	m_pMS = CSGD_MessageSystem::GetInstance();
	m_pD = CSGD_Dispatcher::GetInstance();
	ErG_DirectShow::GetInstance()->Init(hWnd);

	m_dwTimeStamp = GetTickCount();
	
	

	if(bWindowed)
		m_Flags.TurnOn(GAME_WINDOWED);
	else
		m_Flags.TurnOff(GAME_WINDOWED);

	m_pD3D->InitDirect3D(hWnd,nWidth,nHeight,bWindowed);
	m_pTM->InitTextureManager(m_pD3D->GetDirect3DDevice(),m_pD3D->GetSprite());
	m_pDS->InitDirectSound(hWnd);
	m_pWM->InitWaveManager(hWnd,m_pDS->GetDSObject());
	m_pDI->InitDevices(hWnd, hInstance);

	m_pWorld->Init();
	
	//REGISTER CLASS TYPES
	m_pOF->RegisterClassType<CPlayer>("CPlayer");
	m_pOF->RegisterClassType<CEnemy>("CEnemy");
	m_pOF->RegisterClassType<CBullet>("CBullet");
	m_pOF->RegisterClassType<CShield>("CShield");
	m_pOF->RegisterClassType<CMenuItem>("CMenuItem");
	m_pOF->RegisterClassType<CMiniBoss>("CMiniBoss");
	m_pOF->RegisterClassType<CBoss>("CBoss");
	m_pOF->RegisterClassType<CPickup>("CPickup");
	m_pOF->RegisterClassType<CBackground>("CBackground");
	m_pOF->RegisterClassType<CMissile>("CMissile");



	for(int i = 0; i < 8; i++)
	{
		m_pMenuItem[i] = (CMenuItem*)m_pOF->CreateObject("CMenuItem");
	}
	for(int i = 0; i<3;i++)
		m_pBG[i] = (CBackground*)m_pOF->CreateObject("CBackground");
	//INITMENUITEMS
	//Background
	m_pMenuItem[0]->SetID(m_pTM->LoadTexture("ErG_BsLogo.png", D3DCOLOR_XRGB(0,0,0)));
	m_pMenuItem[0]->SetPosition((SCREEN_WIDTH>>1)-300,0);
	//MenuItem1
	m_pMenuItem[1]->SetID(m_pTM->LoadTexture("ErG_BsPlay.png", D3DCOLOR_XRGB(0,0,0)));
	m_pMenuItem[1]->SetPosition(SCREEN_WIDTH>>1,SCREEN_HEIGHT>>1 );
	//MenuItem2
	m_pMenuItem[2]->SetID(m_pTM->LoadTexture("ErG_BsExit.png", D3DCOLOR_XRGB(0,0,0)));
	m_pMenuItem[2]->SetPosition(SCREEN_WIDTH>>1,(SCREEN_HEIGHT>>1) + 30);
	//MenuCurrentSelection
	m_pMenuItem[3]->SetID(m_pTM->LoadTexture("SGD_MenuCurrent.bmp", D3DCOLOR_XRGB(0,0,0)));
	m_pMenuItem[3]->SetPosition((SCREEN_WIDTH>>1) - 30,(SCREEN_HEIGHT>>1) + 10);
	//WinConditionDisplay
	m_pMenuItem[4]->SetID(m_pTM->LoadTexture("SGD_Win.bmp", D3DCOLOR_XRGB(0,0,0)));
	m_pMenuItem[4]->SetPosition(SCREEN_WIDTH>>1,SCREEN_HEIGHT-100);
	//LoseConditionDisplay
	m_pMenuItem[5]->SetID(m_pTM->LoadTexture("SGD_Lose.bmp", D3DCOLOR_XRGB(0,0,0)));
	m_pMenuItem[5]->SetPosition(SCREEN_WIDTH>>1,SCREEN_HEIGHT-100);
	//DifficultySelection on play
	m_pMenuItem[6]->SetID(m_pTM->LoadTexture("ErG_BsDifficulty.png", D3DCOLOR_XRGB(0,0,0)));
	m_pMenuItem[6]->SetPosition(SCREEN_WIDTH>>1, SCREEN_HEIGHT>>1);
	//RESUME
	m_pMenuItem[7]->SetID(m_pTM->LoadTexture("ErG_BsResume.png", D3DCOLOR_XRGB(0,0,0)));
	m_pMenuItem[7]->SetPosition(SCREEN_WIDTH>>1, SCREEN_HEIGHT>>1);

	//INIT BACKGROUND IMAGES
	m_pBG[0]->SetID(m_pTM->LoadTexture("ErG_ParalaxBIG.png", D3DCOLOR_XRGB(0,0,0)));
	m_pBG[0]->SetPosition(100,2400);
	m_pBG[0]->SetBounds(800,3000);
	m_pBG[0]->SetState(CBackground::eTrans::eTLEVEL_TWO);
	m_pBG[0]->SetName("BG_0");
	m_pBG[0]->SetVelocity(0,-2.0f);

	/*m_pBG[1]->SetID(m_pTM->LoadTexture("ErG_ParalaxBIG.png", D3DCOLOR_XRGB(0,0,0)));
	m_pBG[1]->SetPosition(0,600);
	m_pBG[1]->SetBounds(800,3000);
	m_pBG[1]->SetState(CBackground::eTrans::eTLEVEL_TWO);
	m_pBG[1]->SetName("BG_1");
	m_pBG[1]->SetVelocity(0,-0.2f);*/

	m_pOM->AddObject(m_pBG[0]->GetName(), m_pBG[0]);

	





	m_pShip = (CPlayer*)m_pOF->CreateObject("CPlayer");
	
	
	m_pShip->SetID(m_pTM->LoadTexture("ErG_TestViper.png", D3DCOLOR_XRGB(0,0,0)));
	m_pShip->SetBounds(32,64);
	
	
	
	//Add
	m_pShip->SetName("Player");
	m_pShip->SetType(CBase::eType::OBJECT_PLAYER);
	

	m_pOM->AddObject(m_pShip->GetName(), m_pShip);
	
	//REGISTER EVENTS
	m_pD->RegisterClient("Player.Move.Left", m_pShip);
	m_pD->RegisterClient("Player.Move.Right", m_pShip);
	m_pD->RegisterClient("Player.Move.Up", m_pShip);
	m_pD->RegisterClient("Player.Move.Down", m_pShip);
	m_pD->RegisterClient("Player.Move.Stop", m_pShip);
	//Release
	
	m_pShip->Release();
	
	/*for(int i = 0; i < 3; i++)
	{
		m_pShield[i]->Release();
	}*/
	

	m_PlayerLoc.dX = 0;
	m_PlayerLoc.dY = 0;
	m_BossLoc.dX = (SCREEN_WIDTH>>1)-32;
	m_BossLoc.dY = 100;

	m_vctGameGravity.dX	= 0.0f;
	m_vctGameGravity.dY = .50f;
	
	//REGSITER
	m_Particle = m_pTM->LoadTexture("ErG_Spark.bmp", D3DCOLOR_XRGB(0,0,0));
	//g_pOF->RegisterClassType<CBase>("CBase");
	for (int i = 0; i < MAX_PARTICLES; i++)
	{
		m_PlayerParticles[i].bAlive				= true;
		
		m_PlayerParticles[i].pntLoc.dX			= m_PlayerLoc.dX;
		m_PlayerParticles[i].pntLoc.dY			= m_PlayerLoc.dY;

		m_PlayerParticles[i].vctVel.dX			= float(RR(-2, 2)) * (rand()%3);
		m_PlayerParticles[i].vctVel.dY			= float(RR(-2, 2)) * (rand()%3);

		m_PlayerParticles[i].vctGravity.dX		= m_vctGameGravity.dX;
		m_PlayerParticles[i].vctGravity.dY		= m_vctGameGravity.dY;

		m_PlayerParticles[i].nLifeTime			= RR(1000, 3000);
		m_PlayerParticles[i].dwTimer				= GetTickCount();

		m_PlayerParticles[i].nBMPID				= m_Particle;
		m_PlayerParticles[i].fScaleX				= .25f;
		m_PlayerParticles[i].fScaleY				= .25f;

		m_PlayerParticles[i].nR					= (rand() % 255);
		m_PlayerParticles[i].nG					= (rand() % 255);
		m_PlayerParticles[i].nB					= (rand() % 255);
		m_PlayerParticles[i].nA					= 255;
	}

	for (int i = 0; i < MAX_PARTICLES; i++)
	{
		m_BossParticles[i].bAlive				= true;
		
		m_BossParticles[i].pntLoc.dX			= m_BossLoc.dX;
		m_BossParticles[i].pntLoc.dY			= m_BossLoc.dY;

		m_BossParticles[i].vctVel.dX			= float(RR(-2, 2)) * (rand()%3);
		m_BossParticles[i].vctVel.dY			= float(RR(-2, 2)) * (rand()%3);

		m_BossParticles[i].vctGravity.dX		= m_vctGameGravity.dX;
		m_BossParticles[i].vctGravity.dY		= m_vctGameGravity.dY;

		m_BossParticles[i].nLifeTime			= RR(1000, 3000);
		m_BossParticles[i].dwTimer				= GetTickCount();

		m_BossParticles[i].nBMPID				= m_Particle;
		m_BossParticles[i].fScaleX				= .25f;
		m_BossParticles[i].fScaleY				= .25f;

		m_BossParticles[i].nR					= (rand() % 255);
		m_BossParticles[i].nG					= (rand() % 255);
		m_BossParticles[i].nB					= (rand() % 255);
		m_BossParticles[i].nA					= 255;
	}
	m_pMS->SetMsgProc(GameMsgProc);
	m_pWorld->SetEnemyCount(0);
	//m_pWM->Play(m_pWorld->GetGameMusic(), DSBPLAY_LOOPING);
	ErG_DirectShow::GetInstance()->Play(m_pWorld->GetMPTHREE());
	m_pWorld->SetLevel(1);
	m_pWorld->SetScore(0);
	m_pWorld->SetTime(GetTickCount());
	m_pWorld->SetLives(3);
	m_pWorld->SetWeaponLevel(1);
	m_pWorld->SetMenuSelection(CWorld::eMenu::SELECT_PLAY);

	return true;
}
bool CGameClass::GameMain()
{

	//input
	m_pDI->ReadDevices();
	//MENU STATE
	if(m_pWorld->GetMenuState() == CWorld::eMState::MENU_ON)
	{
		
		if(m_pDI->GetBufferedKey(DIK_DOWN))
		{
			if(m_pWorld->GetMenuSelection() == CWorld::eMenu::SELECT_PLAY)
			{
				m_pWM->Play(m_pWorld->GetMenuMoveSound());
				m_pMenuItem[3]->SetYPos(m_pMenuItem[3]->GetYPos()+35);
				m_pWorld->SetMenuSelection(CWorld::eMenu::SELECT_EXIT);
			}
		}

		if(m_pDI->GetBufferedKey(DIK_UP))
		{
			if(m_pWorld->GetMenuSelection() == CWorld::eMenu::SELECT_EXIT)
			{
				m_pWM->Play(m_pWorld->GetMenuMoveSound());
				m_pMenuItem[3]->SetYPos(m_pMenuItem[3]->GetYPos()-35);
				m_pWorld->SetMenuSelection(CWorld::eMenu::SELECT_PLAY);
			}
		}

		if(m_pDI->GetBufferedKey(DIK_RETURN))
		{
			if(m_pWorld->GetMenuSelection() == CWorld::eMenu::SELECT_EXIT)
			{
				m_pWM->Play(m_pWorld->GetMenuSelectSound());
				PostQuitMessage(0);
			}
			else
			{
				m_pWM->Play(m_pWorld->GetMenuSelectSound());
				m_pWorld->SetMenuState(CWorld::eMState::MENU_DIFFICULTY);
				m_pWorld->SetMenuSelection(CWorld::eMenu::SELECT_EASY);
				m_pWorld->SetEndCondition(CWorld::eEnd::END_NONE);
				return true;
			}
		}
		//MENU RENDER
		m_pD3D->Clear(0,0,0);
		m_pD3D->DeviceBegin();
		m_pD3D->SpriteBegin();

		m_pOM->RenderObjects();
		for(int i = 0; i < 4; i++)
		{
			m_pMenuItem[i]->Render();
		}
		if(!m_pWorld->GetEndCondition() == CWorld::eEnd::END_NONE)
		{
			if(m_pWorld->GetEndCondition() == CWorld::eEnd::END_WIN)
				m_pMenuItem[4]->Render();
			else
				m_pMenuItem[5]->Render();
		}
		

		m_pD3D->SpriteEnd();
		m_pD3D->DeviceEnd();
		m_pD3D->Present();
		return true;
	}

	if(m_pWorld->GetMenuState() == CWorld::eMState::MENU_DIFFICULTY)
	{
		if(m_pDI->GetBufferedKey(DIK_RIGHT))
		{
			if((m_pWorld->GetMenuSelection() == CWorld::eMenu::SELECT_EASY) || (m_pWorld->GetMenuSelection() == CWorld::eMenu::SELECT_MEDIUM))
			{
				m_pWM->Play(m_pWorld->GetMenuMoveSound());
				if(m_pWorld->GetMenuSelection() == CWorld::eMenu::SELECT_EASY)
				{
					m_pMenuItem[3]->SetXPos(m_pMenuItem[3]->GetXPos()+80);
					m_pWorld->SetMenuSelection(CWorld::eMenu::SELECT_MEDIUM);
				}
				else
				{
					m_pMenuItem[3]->SetXPos(m_pMenuItem[3]->GetXPos()+120);
					m_pWorld->SetMenuSelection(CWorld::eMenu::SELECT_HARD);
				}

			}
		}

		if(m_pDI->GetBufferedKey(DIK_LEFT))
		{
			if((m_pWorld->GetMenuSelection() == CWorld::eMenu::SELECT_MEDIUM) || (m_pWorld->GetMenuSelection() == CWorld::eMenu::SELECT_HARD))
			{
				m_pWM->Play(m_pWorld->GetMenuMoveSound());
				if(m_pWorld->GetMenuSelection() == CWorld::eMenu::SELECT_MEDIUM)
				{
					m_pMenuItem[3]->SetXPos(m_pMenuItem[3]->GetXPos()-80);
					m_pWorld->SetMenuSelection(CWorld::eMenu::SELECT_EASY);
				}
				else
				{
					m_pMenuItem[3]->SetXPos(m_pMenuItem[3]->GetXPos()-120);
					m_pWorld->SetMenuSelection(CWorld::eMenu::SELECT_MEDIUM);
				}
			}
		}

		if(m_pDI->GetBufferedKey(DIK_RETURN))
		{
			if(m_pWorld->GetMenuSelection() == CWorld::eMenu::SELECT_EASY)
			{
				m_pWM->Play(m_pWorld->GetMenuSelectSound());
				m_pWorld->SetDifficulty(1);
				m_pWorld->SetMenuState(CWorld::eMState::MENU_OFF);
				m_pWorld->SetEndCondition(CWorld::eEnd::END_NONE);
				return true;

			}
			else if(m_pWorld->GetMenuSelection() == CWorld::eMenu::SELECT_MEDIUM)
			{
				m_pWM->Play(m_pWorld->GetMenuSelectSound());
				m_pWorld->SetDifficulty(2);
				m_pWorld->SetMenuState(CWorld::eMState::MENU_OFF);
				m_pWorld->SetEndCondition(CWorld::eEnd::END_NONE);
				return true;
			}
			else
			{
				m_pWM->Play(m_pWorld->GetMenuSelectSound());
				m_pWorld->SetDifficulty(3);
				m_pWorld->SetMenuState(CWorld::eMState::MENU_OFF);
				m_pWorld->SetEndCondition(CWorld::eEnd::END_NONE);
				return true;
			}

		}
		m_pD3D->Clear(0,0,0);
		m_pD3D->DeviceBegin();
		m_pD3D->SpriteBegin();
		

		m_pOM->RenderObjects();
		m_pMenuItem[0]->Render();
		m_pMenuItem[3]->Render();
		m_pMenuItem[6]->Render();
		

		m_pD3D->SpriteEnd();
		m_pD3D->DeviceEnd();
		m_pD3D->Present();
		return true;

	}

	if(m_pWorld->GetMenuState() == CWorld::eMState::MENU_INGAME)
	{
		if(m_pDI->GetBufferedKey(DIK_DOWN))
		{
			if(m_pWorld->GetMenuSelection() == CWorld::eMenu::SELECT_RESUME)
			{
				m_pWM->Play(m_pWorld->GetMenuMoveSound());
				m_pMenuItem[3]->SetYPos(m_pMenuItem[3]->GetYPos()+35);
				m_pWorld->SetMenuSelection(CWorld::eMenu::SELECT_EXIT);
			}
		}

		if(m_pDI->GetBufferedKey(DIK_UP))
		{
			if(m_pWorld->GetMenuSelection() == CWorld::eMenu::SELECT_EXIT)
			{
				m_pWM->Play(m_pWorld->GetMenuMoveSound());
				m_pMenuItem[3]->SetYPos(m_pMenuItem[3]->GetYPos()-35);
				m_pWorld->SetMenuSelection(CWorld::eMenu::SELECT_RESUME);
			}
		}

		if(m_pDI->GetBufferedKey(DIK_RETURN))
		{
			if(m_pWorld->GetMenuSelection() == CWorld::eMenu::SELECT_EXIT)
			{
				m_pWM->Play(m_pWorld->GetMenuSelectSound());
				PostQuitMessage(0);
			}
			else
			{
				m_pWM->Play(m_pWorld->GetMenuSelectSound());
				m_pWorld->SetMenuState(CWorld::eMState::MENU_OFF);
				m_pWorld->SetMenuSelection(CWorld::eMenu::SELECT_RESUME);
				m_pWorld->SetEndCondition(CWorld::eEnd::END_NONE);
				return true;
			}
		}
		//MENU RENDER
		m_pD3D->Clear(0,0,0);
		m_pD3D->DeviceBegin();
		m_pD3D->SpriteBegin();

		m_pOM->RenderObjects();
		
		m_pMenuItem[0]->Render();
		m_pMenuItem[2]->Render();
		m_pMenuItem[3]->Render();
		m_pMenuItem[7]->Render();

			

		m_pD3D->SpriteEnd();
		m_pD3D->DeviceEnd();
		m_pD3D->Present();
		return true;

	}
	
	static int nLastTime = 0;
	
	if((nLastTime == 0) || ((GetTickCount() - m_pWorld->GetTime()) > (4000 - (1000*m_pWorld->GetDifficulty()))))
	{
		CSGD_MessageSystem::GetInstance()->SendMsg(new CCreateEnemyMessage(CWorld::eGAME_MESSAGES::eGM_CREATE_ENEMY));
		nLastTime++;
		m_pWorld->SetScore(m_pWorld->GetScore()+10);
		m_pWorld->SetTime(GetTickCount());
	}
	

	m_pWM->Update();
	m_pOM->UpdateObjects();
// GAME STATE
	
	 	
	
	//Leave?
	if(m_pDI->GetKey(DIK_ESCAPE))
	{
		m_pWorld->SetMenuState(CWorld::eMState::MENU_INGAME);
		m_pWorld->SetMenuSelection(CWorld::eMenu::SELECT_RESUME);
	}


	if(m_pDI->GetBufferedKey(DIK_F1))
		m_pMM->LogStatus();

	////////////////////////////CHEETZ//
	if(m_pDI->GetBufferedKey(DIK_F12))//
		m_pWorld->Cheetz_Weapon();	  //
	if(m_pDI->GetBufferedKey(DIK_F11))//
		m_pWorld->Cheetz_God();		  //
	if(m_pDI->GetBufferedKey(DIK_F10))//
		m_pWorld->Cheetz_Life();	  //
	/////////////////////////ENDCHEETZ//
	//DEBUGGINGKEYS//
	if(m_pDI->GetBufferedKey(DIK_0))
		m_pWorld->SetWeaponLevel(m_pWorld->GetWeaponLevel()+1);
	if(m_pDI->GetBufferedKey(DIK_9))
		m_pMS->SendMsg(new CCreateEnemyMessage(CWorld::eGAME_MESSAGES::eGM_CREATE_BOSS));

	//SetWindowed
	if(m_pDI->GetKey(DIK_LMENU) && m_pDI->GetBufferedKey(DIK_RETURN))
	{		
		if(CheckWindowed())
		{
			SetWindowed(CGameClass::eWindowed::WINDOW_NO);
			m_pD3D->ChangeDisplayParam(SCREEN_WIDTH,SCREEN_HEIGHT,CheckWindowed());
		}
		else
		{
			SetWindowed(CGameClass::eWindowed::WINDOW_YES);
			m_pD3D->ChangeDisplayParam(SCREEN_WIDTH,SCREEN_HEIGHT,CheckWindowed());
		}
	
	}
	
	
	


	//Simulation
	m_pMS->ProcessMessages();
	m_pD->ProcessEvents();
	m_pOM->CheckCollisions();

	if((m_pWorld->GetScore()%1000) == 0)
	{
		m_pWorld->SetLives(m_pWorld->GetLives()+1);
		m_pWorld->SetScore(m_pWorld->GetScore()+10);
		m_pWorld->SetLevel(m_pWorld->GetLevel()+1);
		if(!(m_pWorld->GetLevel()%3))
			CSGD_MessageSystem::GetInstance()->SendMsg(new CCreateEnemyMessage(CWorld::eGAME_MESSAGES::eGM_CREATE_BOSS));
		if(m_pWorld->GetLevel()>1)
			CSGD_MessageSystem::GetInstance()->SendMsg(new CCreateEnemyMessage(CWorld::eGAME_MESSAGES::eGM_CREATE_MINIBOSS));			

	}
	
	
	
	
	
	

	// GAME RENDER
	int m_nStarfield = m_pTM->LoadTexture("ErG_StarField.png");
	//render
	m_pD3D->Clear(0,0,0);
	m_pD3D->DeviceBegin();
	m_pD3D->SpriteBegin();
	//PARTICLE SYSTEM DRAW
	if(m_pWorld->GetPlayerSmoke())
	{
		for (int i = 0; i < MAX_PARTICLES; i++)
		{
			//	Update and Draw only if the particle is alive.
			if (m_PlayerParticles[i].bAlive)
			{
				//	Update the Particle.
				m_PlayerParticles[i].pntLoc.dX += m_PlayerParticles[i].vctVel.dX;
				m_PlayerParticles[i].pntLoc.dY += m_PlayerParticles[i].vctVel.dY;

				//	Apply Phsycis.
				m_PlayerParticles[i].vctVel.dX += m_PlayerParticles[i].vctGravity.dX;
				m_PlayerParticles[i].vctVel.dY += m_PlayerParticles[i].vctGravity.dY;

				/*	Linear Interpolation:
					percent = (CurrentTime - StartTime) / Life Time;
					newpos  = startpos + (percent * (endpos - startpos));
				*/
				float fPercent = ((float)GetTickCount() - m_PlayerParticles[i].dwTimer) /
									m_PlayerParticles[i].nLifeTime;

			int nNewR = m_PlayerParticles[i].nR + (fPercent * (m_PlayerParticles[i].nFR - m_PlayerParticles[i].nR));
			int nNewG = m_PlayerParticles[i].nG + (fPercent * (m_PlayerParticles[i].nFG - m_PlayerParticles[i].nG));
			int nNewB = m_PlayerParticles[i].nB + (fPercent * (m_PlayerParticles[i].nFB - m_PlayerParticles[i].nB));
			int nNewA = m_PlayerParticles[i].nA + (fPercent * (m_PlayerParticles[i].nFA - m_PlayerParticles[i].nA));

			//	Make the particles follow a path.
			//static DWORD dwMoveTimer = GetTickCount();
			//float fMovePercent = ((float)GetTickCount() - dwMoveTimer) / 2000;
			
			//m_NewX = g_pntParticleLoc.dX + (fMovePercent * (600 - g_pntParticleLoc.dX));


				//	Is it time for a new Particle.
				if ((GetTickCount() - m_PlayerParticles[i].dwTimer) > m_PlayerParticles[i].nLifeTime)
				{
					m_PlayerParticles[i].bAlive = false;

					PlayerParticle();
						break;
				}

				//	Draw the current Particle.
				m_pTM->Draw(m_PlayerParticles[i].nBMPID,
							m_PlayerParticles[i].pntLoc.dX, m_PlayerParticles[i].pntLoc.dY,
							m_PlayerParticles[i].fScaleX,   m_PlayerParticles[i].fScaleY,
							NULL, 0, 0 , 0, 
							D3DCOLOR_ARGB(nNewA, nNewR, nNewG, nNewB));
			}
		}
	}

		if(m_pWorld->GetBossExplode())
		{
			for (int i = 0; i < MAX_PARTICLES; i++)
			{
				//	Update and Draw only if the particle is alive.
				if (m_BossParticles[i].bAlive)
				{
					//	Update the Particle.
					m_BossParticles[i].pntLoc.dX += m_BossParticles[i].vctVel.dX;
					m_BossParticles[i].pntLoc.dY += m_BossParticles[i].vctVel.dY;

					//	Apply Phsycis.
					m_BossParticles[i].vctVel.dX += m_BossParticles[i].vctGravity.dX;
					m_BossParticles[i].vctVel.dY += m_BossParticles[i].vctGravity.dY;

					/*	Linear Interpolation:
						percent = (CurrentTime - StartTime) / Life Time;
						newpos  = startpos + (percent * (endpos - startpos));
					*/
					float fPercent = ((float)GetTickCount() - m_BossParticles[i].dwTimer) /
										m_BossParticles[i].nLifeTime;

				int nNewR = m_BossParticles[i].nR + (fPercent * (m_BossParticles[i].nFR - m_BossParticles[i].nR));
				int nNewG = m_BossParticles[i].nG + (fPercent * (m_BossParticles[i].nFG - m_BossParticles[i].nG));
				int nNewB = m_BossParticles[i].nB + (fPercent * (m_BossParticles[i].nFB - m_BossParticles[i].nB));
				int nNewA = m_BossParticles[i].nA + (fPercent * (m_BossParticles[i].nFA - m_BossParticles[i].nA));

				//	Make the particles follow a path.
				//static DWORD dwMoveTimer = GetTickCount();
				//float fMovePercent = ((float)GetTickCount() - dwMoveTimer) / 2000;
				
				//m_NewX = g_pntParticleLoc.dX + (fMovePercent * (600 - g_pntParticleLoc.dX));


					//	Is it time for a new Particle.
					if ((GetTickCount() - m_BossParticles[i].dwTimer) > m_BossParticles[i].nLifeTime)
					{
						m_BossParticles[i].bAlive = false;
						m_pWorld->SetBossExplode(false);
						//BossParticle();
							
					}

					//	Draw the current Particle.
					m_pTM->Draw(m_BossParticles[i].nBMPID,
								m_BossParticles[i].pntLoc.dX, m_BossParticles[i].pntLoc.dY,
								m_BossParticles[i].fScaleX,   m_BossParticles[i].fScaleY,
								NULL, 0, 0 , 0, 
								D3DCOLOR_ARGB(nNewA, nNewR, nNewG, nNewB));
				}
			}
			
		}

	

	m_pTM->Draw(m_nStarfield,0,0);
	m_pOM->RenderObjects();

	m_pD3D->SpriteEnd();
	m_pD3D->DeviceEnd();
	
	char buffer[128];
	wsprintf(buffer,"Score:%d", m_pWorld->GetScore());
	m_pD3D->DrawText(buffer,10,10,255,255,255);
	wsprintf(buffer,"Lives:%d", m_pWorld->GetLives());
	m_pD3D->DrawText(buffer,10,30,255,255,255);
	wsprintf(buffer,"Level:%d", m_pWorld->GetLevel());
	m_pD3D->DrawText(buffer,10,50,255,255,255);
	wsprintf(buffer,"Weapon Level:%d", m_pWorld->GetWeaponLevel());
	m_pD3D->DrawText(buffer,10, SCREEN_HEIGHT-30,255,255,255);
	m_pD3D->Present();
	return true;
}
bool CGameClass::GameShutdown()
{
	
	for(int i = 0; i < 8; i++)
	{
		m_pMenuItem[i]->Release();
	}
	m_pOM->RemoveAllObjects();
	m_pOF->ShutdownObjectFactory();
	m_pDI->ShutdownDirectInput();
	m_pWM->ShutdownWaveManager();
	m_pDS->ShutdownDirectSound();
	m_pTM->ShutdownTextureManager();
	m_pD3D->ShutdownDirect3D();
	m_pMM->Shutdown();
	return true;
}

bool CGameClass::CheckWindowed()
{
	return m_bWindowed;
}

void CGameClass::SetWindowed(bool val)
{
	m_bWindowed = val;
}

bool CGameClass::GameReset()
{
	
	m_pWorld->SetEnemyYPos(0);
	m_pWorld->SetEnemyCount(0);
	m_pOM->RemoveAllObjects();
	m_pShip = (CPlayer*)m_pOF->CreateObject("CPlayer");
	
	

	
	

	m_pShip->SetID(m_pTM->LoadTexture("ErG_TestViper.png", D3DCOLOR_XRGB(0,0,0)));
	m_pShip->SetBounds(32,64);
	
	
	
	//Add
	m_pShip->SetName("Player");
	m_pShip->SetType(CBase::eType::OBJECT_PLAYER);
	

	m_pOM->AddObject(m_pShip->GetName(), m_pShip);

	m_pD->RegisterClient("Player.Move.Left", m_pShip);
	m_pD->RegisterClient("Player.Move.Right", m_pShip);
	m_pD->RegisterClient("Player.Move.Up", m_pShip);
	m_pD->RegisterClient("Player.Move.Down", m_pShip);
	m_pD->RegisterClient("Player.Move.Stop", m_pShip);
	
	

	//Release
	m_pShip->Release();	
	m_pBG[0]->SetID(m_pTM->LoadTexture("ErG_ParalaxBIG.png", D3DCOLOR_XRGB(0,0,0)));
	m_pBG[0]->SetPosition(100,2400);
	m_pBG[0]->SetBounds(800,3000);
	m_pBG[0]->SetState(CBackground::eTrans::eTLEVEL_TWO);
	m_pBG[0]->SetName("BG_0");
	m_pBG[0]->SetVelocity(0,-2.0f);

	m_pOM->AddObject(m_pBG[0]->GetName(), m_pBG[0]);


	//REGSITER
	//g_pOF->RegisterClassType<CBase>("CBase");
	
	//m_pWM->Play(m_pWorld->GetGameMusic(), DSBPLAY_LOOPING);
	m_pWorld->SetMenuSelection(CWorld::eMenu::SELECT_PLAY);
	m_pMenuItem[3]->SetPosition((SCREEN_WIDTH>>1) - 30,(SCREEN_HEIGHT>>1) + 10);
	m_pWorld->SetLevel(1);
	m_pWorld->SetScore(0);
	m_pWorld->SetTime(GetTickCount());
	m_pWorld->SetLives(3);
	m_pWorld->SetWeaponLevel(1);
	

	return true;

}

void CGameClass::PlayerParticle()
{
	//	Update or Re-Initialize all of our Particles.
	for (int i = 0; i < MAX_PARTICLES; i++)
	{
		//	Update if the particle is not alive.
		//	Re-Initialize if the Particle System says so.
		if (!m_PlayerParticles[i].bAlive || m_bParticleInit)
		{
			m_PlayerParticles[i].bAlive				= true;
			
			m_PlayerParticles[i].pntLoc.dX			= m_PlayerLoc.dX;
			m_PlayerParticles[i].pntLoc.dY			= m_PlayerLoc.dY;

			m_PlayerParticles[i].vctVel.dX			= float(RR(-5, 5));
			m_PlayerParticles[i].vctVel.dY			= float(RR(-5, 5));

			m_PlayerParticles[i].vctGravity.dX		= m_vctGameGravity.dX;
			m_PlayerParticles[i].vctGravity.dY		= m_vctGameGravity.dY;

			m_PlayerParticles[i].nLifeTime			= RR(1000, 3000);
			m_PlayerParticles[i].dwTimer			= GetTickCount();

			m_PlayerParticles[i].nBMPID				= m_Particle;
			m_PlayerParticles[i].fScaleX				= .25f;
			m_PlayerParticles[i].fScaleY				= .25f;

			m_PlayerParticles[i].nR					= (rand() % 255);
			m_PlayerParticles[i].nG					= (rand() % 255);
			m_PlayerParticles[i].nB					= (rand() % 255);
			m_PlayerParticles[i].nA					= (rand() % 255);

			m_PlayerParticles[i].nFR					= (rand() % 255);
			m_PlayerParticles[i].nFG					= (rand() % 255);
			m_PlayerParticles[i].nFB					= (rand() % 255);
			m_PlayerParticles[i].nFA					= (rand() % 255);
		}
	}
}

void CGameClass::BossParticle()
{
	//	Update or Re-Initialize all of our Particles.
	for (int i = 0; i < MAX_PARTICLES; i++)
	{
		//	Update if the particle is not alive.
		//	Re-Initialize if the Particle System says so.
		if (!m_BossParticles[i].bAlive || m_bParticleInit)
		{
			m_BossParticles[i].bAlive				= true;
			
			m_BossParticles[i].pntLoc.dX			= RR((int)(m_BossLoc.dX - 5),
													 (int)(m_BossLoc.dX + 5));
			m_BossParticles[i].pntLoc.dY			= RR((int)(m_BossLoc.dY - 5),
													 (int)(m_BossLoc.dY + 5));

			m_BossParticles[i].vctVel.dX			= float(RR(-2, 2));
			m_BossParticles[i].vctVel.dY			= float(RR(-2, 2));

			m_BossParticles[i].vctGravity.dX		= m_vctGameGravity.dX;
			m_BossParticles[i].vctGravity.dY		= m_vctGameGravity.dY;

			//	Normalize the vector.  This gives us our circular effect.
			m_BossParticles[i].vctVel = Vector2DNormalize(m_BossParticles[i].vctVel);

			//	Speed up our velocity components.
			m_BossParticles[i].vctVel.dX *= 10.0f;
			m_BossParticles[i].vctVel.dY *= 10.0f;

			m_BossParticles[i].nLifeTime			= RR(1000, 3000);
			m_BossParticles[i].dwTimer				= GetTickCount();

			m_BossParticles[i].nBMPID				= m_Particle;
			m_BossParticles[i].fScaleX				= .25f;
			m_BossParticles[i].fScaleY				= .25f;

			m_BossParticles[i].nR					= 255;
			m_BossParticles[i].nG					= 0;
			m_BossParticles[i].nB					= 0;
			m_BossParticles[i].nA					= 255;

			m_BossParticles[i].nFR					= 255;
			m_BossParticles[i].nFG					= 255;
			m_BossParticles[i].nFB					= 0;
			m_BossParticles[i].nFA					= 0;
		}
	}
}