////////////////////////////////////////////////////////////////////////////
//	File	:	"CGameClass.h"
//	Author	:	Eric Green
//	Purpose	:	Contains the functionality for my application. This includes
//				initialization, execution, and shutdown
////////////////////////////////////////////////////////////////////////////

#pragma once
#include "CSGD_Direct3D.h"
#include "CSGD_TextureManager.h"
#include "CSGD_DirectSound.h"
#include "CSGD_WaveManager.h"
#include "CSGD_DirectInput.h"

#include "CSGD_ObjectManager.h"
#include "CSGD_MessageSystem.h"
#include "CSGD_Dispatcher.h"
#include "CSGD_Flags.h"
#include "CWorld.h"
#include "CBase.h"
#include "CPlayer.h"
#include "CBullet.h"
#include "CEnemy.h"
#include "CShield.h"
#include "CMenuItem.h"
#include "CMiniBoss.h"
#include "CBoss.h"
#include "CMissile.h"
#include "CPickup.h"
#include "CBackground.h"
#include <Vector>
#include <string>
#include "ErG_DirectShow.h"
using std::string;
#include "CSGD_ObjectFactory.h"
#include "SGD_Math.h"

#define GAME_WINDOWED BIT_ONE
#define MAX_PARTICLES 100

class CSGD_MemoryManager;

class CGameClass
{
private:
	struct tParticle
	{
	//	int						nWidth, nHeight;		//	For Collision.
		bool					bAlive;					//	Is it alive.

		tPoint2D				pntLoc;					//	Particle Location.
		tVector2D				vctVel;					//	Velocity of this particle.
		tVector2D				vctGravity;				//	Velocity for this particle.

		int						nLifeTime;				//	How long to live. MS.
		DWORD					dwTimer;				//	Always need a timer.

		int						nBMPID;					//	Image to draw for this particle.
		float					fScaleX, fScaleY;		//	To Scale the particle.

		int						nA, nR, nG, nB;			//	ARGB Color for the particle.
		int						nFA, nFR, nFG, nFB;		//	Ending colors.
	};

	//particle stuffs
	tParticle m_PlayerParticles[MAX_PARTICLES];
	tParticle m_BossParticles[MAX_PARTICLES];
	tPoint2D  m_PlayerLoc;
	tPoint2D  m_BossLoc;
	tVector2D m_vctGameGravity;
	bool m_bParticleInit;
	int m_Particle;
	int m_NewX;
	//end particle stuffs

	CSGD_Direct3D						*m_pD3D;
	CSGD_TextureManager					*m_pTM;
	CSGD_DirectSound					*m_pDS;
	CSGD_WaveManager					*m_pWM;
	CSGD_DirectInput					*m_pDI;
	CSGD_ObjectFactory<string, CBase>	*m_pOF;
	CSGD_ObjectManager					*m_pOM;
	CWorld								*m_pWorld;
	CSGD_MemoryManager					*m_pMM;
	CSGD_MessageSystem					*m_pMS;
	CSGD_Dispatcher						*m_pD;

	CSGD_Flags			m_Flags;

	CPlayer* m_pShip;
	CBullet* m_pBullet;
	CEnemy* m_pEnemy;
	CShield* m_pShield[3];
	CMenuItem* m_pMenuItem[8];
	CMiniBoss* m_pMiniBoss;
	CPickup* m_pPickup;
	CBackground* m_pBG[3];

	bool m_bWindowed;
	DWORD m_dwTimeStamp;

	//singleton instance for this class
	static CGameClass * m_pInstance;
	//constructor
	CGameClass();
	//copy constructor
	CGameClass(const CGameClass &ref);
	//Assignment operator
	CGameClass &operator =(const CGameClass &ref);
public:

	enum eWindowed{WINDOW_NO = 0, WINDOW_YES};
	
	
	~CGameClass();
	////////////////////////////////////////////////////////////
	//function:getinstance
	//Purpose:returns the pointer to the instance of the class
	static CGameClass* GetInstance(void);

	/////////
	//function:deleteinstance
	//purpose:clean up teh mess.
	static void DeleteInstance(void);

	////////////////////////////////////////////////////////////
	//	Function	:	GameInit
	//	Purpose		:	Initialize all game data that is needed.
	//
	bool GameInit(HWND hWnd, HINSTANCE hInstance, int nWidth, int nHeight, bool bWindowed);
	
	///////////////////////////////////////////////////////////
	//	Function:GameMain
	//	Purpose	: Runs the game
	bool GameMain(void);
	
	///////////////////////////////////////////////////////////
	//	Function:GameShutdown
	//	Purpose	: Shutdown
	bool GameShutdown(void);

	///////
	//Function:CheckWindowed
	//Purpose:Return if the game should be windowed or not
	bool CheckWindowed();
	///////
	//Function:SetWindowed
	//Purpose:Sets the game to windowed or not
	void SetWindowed(bool val);

	///////
	//Function:GameReset
	//Purpose:Reset the game to starting point
	bool GameReset();

	///////
	//Function:PlayerParticle
	//Purpose:Player particle mechanics
	void PlayerParticle();

	///////
	//Function:BossParticle
	//Purpose:Boss particle mechanics
	void BossParticle();

};