// CMessages.h : all of the messages i want in my application.

#pragma once

#include "Cbase.h"
#include <queue>
using std::queue;



typedef unsigned int MESSAGEID;

class CBaseMessage
{
protected:
	MESSAGEID	m_Msg;
	 
public:
	CBaseMessage(){}
	CBaseMessage(MESSAGEID msg) : m_Msg(msg){}
	virtual ~CBaseMessage(){}

	inline void			SetMessageID(MESSAGEID msg) { m_Msg = msg; }
	inline MESSAGEID	GetMessageID() { return m_Msg; }
};

class CCollisionMessage: public CBaseMessage
{
private:
	//parameters that are speceifc to this message
	CBase *m_pCollider1;	//pointer to first object.
	CBase *m_pCollider2;	//pointer to second object.

public:
	CCollisionMessage() { m_pCollider1 = m_pCollider2 = 0; }
	CCollisionMessage(MESSAGEID msg, CBase *pCol1, CBase *pCol2) :
		CBaseMessage(msg), m_pCollider1(pCol1), m_pCollider2(pCol2) {}
	~CCollisionMessage(){}

	inline CBase* GetCollider1(){return m_pCollider1;}
	inline CBase* GetCollider2(){return m_pCollider2;}

	inline void SetColliders(CBase* pCol1, CBase* pCol2)
	{
		m_pCollider1 = pCol1;
		m_pCollider2 = pCol2;
	}
};

class CMoveMessage: public CBaseMessage
{
private:
	int m_nDirection;
public:
	CMoveMessage(){ m_nDirection = 0;}
	CMoveMessage(MESSAGEID msg, int nDir) : CBaseMessage(msg), m_nDirection(nDir) {}
	~CMoveMessage() {}

	inline int GetDirection(){return m_nDirection;}

	inline void SetDirection(int val){m_nDirection = val;}
};

class CDestroyBulletMessage: public CBaseMessage
{
private:
	void* m_pParam;
public:
	CDestroyBulletMessage(){m_pParam = 0; }
	CDestroyBulletMessage(MESSAGEID msg, CBase* pParam) : 
	 CBaseMessage(msg), m_pParam(pParam) {}
	~CDestroyBulletMessage(){}

	inline void* GetParam(){return m_pParam;}
	inline void SetParam(void* pParam){ m_pParam = pParam;}

};

class CCreateBulletMessage: public CBaseMessage
{
private:
	void* m_pParam;
public:
	CCreateBulletMessage(){m_pParam = 0; }
	CCreateBulletMessage(MESSAGEID msg, CBase* pParam) : 
	 CBaseMessage(msg), m_pParam(pParam) {}
	~CCreateBulletMessage(){}

	inline void* GetParam(){return m_pParam;}
	inline void SetParam(void* pParam){ m_pParam = pParam;}

};

class CCreateEnemyMessage: public CBaseMessage
{
private:
public:
	CCreateEnemyMessage(){}
	CCreateEnemyMessage(MESSAGEID msg) : CBaseMessage(msg) {}
	~CCreateEnemyMessage(){}
};

class CPauseGameMessage: public CBaseMessage
{
private:
	bool m_bPaused;
public:
	CPauseGameMessage(){ m_bPaused = 0;}
	CPauseGameMessage(MESSAGEID msg, bool bPaused) : CBaseMessage(msg), m_bPaused(bPaused) {}
	~CPauseGameMessage(){}

	 inline bool GetPaused(){return m_bPaused;}
	 inline void SetPaused(bool bPaused){m_bPaused = bPaused;}

};
