///////////////////////////
//	File: CMiniBoss.cpp
//	Author:	Eric Green
//	Purpose: Enemy class function definitions
#include "CMiniBoss.h"
#include "CWorld.h"
#include "CSGD_Dispatcher.h"
#include "CSGD_DirectInput.h"
#include "CSGD_TextureManager.h"

#define SCREEN_WIDTH 800
#define SCREEN_HEIGHT 600
#define VEL 2

void CMiniBoss::HandleEvent(CEvent *pEvent)
{
	if(!pEvent) return;
	//handle event
	int velocity =0;

	if(pEvent->GetEventID() == "Enemy.Move.Left")
	{		
		SetXVel(GetXVel()-VEL);
	}
	if(pEvent->GetEventID() == "Enemy.Move.Right")
	{
		SetXVel(GetXVel()+VEL);
	}
	
	if(pEvent->GetEventID() == "Enemy.Move.Stop")
	{
		SetXVel(0);
		SetYVel(0);
	}
}

void CMiniBoss::Update()
{
	
	if(CSGD_DirectInput::GetInstance()->GetBufferedKey(DIK_T))
		SetVelocity(0,0);
	if(GetYPos() < -200)
		SetVelocity(0,GetYVel()+1);
	if(GetYPos() > SCREEN_HEIGHT+200)
		SetVelocity(0,(GetYVel()+1)*-1);
	if(GetHealth() <=3)
		SetState(3);
	else if(GetHealth() <= 6)
		SetState(2);
	else
		SetState(1);
	
	CBase::Update();
}
CMiniBoss::CMiniBoss(void)
{
	SetPosition(0,0);
	SetVelocity(0,.2f);
	SetHealth(3);
}

CMiniBoss::~CMiniBoss(void)
{
}

void CMiniBoss::Render()
{
	/*int Health;
	Health = 85 * GetHealth();
	DWORD color = D3DCOLOR_ARGB(255,255,Health,Health);*/

	if(GetYVel() > 0)
		CSGD_TextureManager::GetInstance()->Draw(GetID(), (int)GetXPos(),(int)GetYPos(),1,1,0,0,0,0);
	/*else
		CSGD_TextureManager::GetInstance()->Draw(GetID(), (int)GetXPos()+GetWidth(),(int)GetYPos()+GetHeight(),-1,-1,0,0,0,0,color);*/
}

