///////////////////////////
//	File: CPlayer.cpp
//	Author:	Eric Green
//	Purpose: Player class function definitions
#include "CPlayer.h"
#include "CMessages.h"
#include "CWorld.h"
#include "CSGD_MessageSystem.h"
#define SCREEN_WIDTH 800
#define SCREEN_HEIGHT 600
#define VEL 4
void CPlayer::HandleEvent(CEvent *pEvent)
{
	if(!pEvent) return;
	//handle event
	int velocity =0;

	if(pEvent->GetEventID() == "Player.Move.Left")
	{
		
		SetXVel(GetXVel()-VEL);
	}

	if(pEvent->GetEventID() == "Player.Move.Right")
	{
		SetXVel(GetXVel()+VEL);
	}
	if(pEvent->GetEventID() == "Player.Move.Up")
	{
		SetYVel(GetYVel()-VEL);
	}
	if(pEvent->GetEventID() == "Player.Move.Down")
	{
		SetYVel(GetYVel()+VEL);
	}
	if(pEvent->GetEventID() == "Player.Move.Stop")
	{
		SetXVel(0);
		SetYVel(0);
	}
}

void CPlayer::Update()
{
	m_pDI = CSGD_DirectInput::GetInstance();
	if(m_pDI->GetKey(DIK_UP))
		CSGD_MessageSystem::GetInstance()->SendMsg(new CMoveMessage(CWorld::eGAME_MESSAGES::eGM_MOVE, CWorld::eDirections::eDIR_UP));
	if(m_pDI->GetKey(DIK_DOWN))
		CSGD_MessageSystem::GetInstance()->SendMsg(new CMoveMessage(CWorld::eGAME_MESSAGES::eGM_MOVE, CWorld::eDirections::eDIR_DOWN));
	if(m_pDI->GetKey(DIK_LEFT))
		CSGD_MessageSystem::GetInstance()->SendMsg(new CMoveMessage(CWorld::eGAME_MESSAGES::eGM_MOVE, CWorld::eDirections::eDIR_LEFT));
	if(m_pDI->GetKey(DIK_RIGHT))
		CSGD_MessageSystem::GetInstance()->SendMsg(new CMoveMessage(CWorld::eGAME_MESSAGES::eGM_MOVE, CWorld::eDirections::eDIR_RIGHT));
	if(m_pDI->GetKey(DIK_Q))
		CSGD_MessageSystem::GetInstance()->SendMsg(new CMoveMessage(CWorld::eGAME_MESSAGES::eGM_MOVE, CWorld::eDirections::eDIR_STOP));

	if(CWorld::GetInstance()->GetWeaponLevel() < 4)
	{
		if(m_pDI->GetBufferedKey(DIK_SPACE))
			CSGD_MessageSystem::GetInstance()->SendMsg(new CCreateBulletMessage(CWorld::eGAME_MESSAGES::eGM_PLAYER_FIRE, this));
	}
	else
		if(m_pDI->GetKey(DIK_SPACE))
			CSGD_MessageSystem::GetInstance()->SendMsg(new CCreateBulletMessage(CWorld::eGAME_MESSAGES::eGM_PLAYER_FIRE, this));


		

	CBase::Update();
	SetVelocity(0,0);
	if(GetHealth() == 1)
		CWorld::GetInstance()->SetPlayerSmoke(true);
	else
		CWorld::GetInstance()->SetPlayerSmoke(false);

	if((CWorld::GetInstance()->GetScore()%500) == 0)
	{
		if(GetHealth() < 3)
		{
			SetHealth(GetHealth()+1);
			CWorld::GetInstance()->SetScore(CWorld::GetInstance()->GetScore()+10);
		}
	}
}

CPlayer::CPlayer(void)
{
	m_pDI = 0;
	SetPosition(SCREEN_WIDTH>>1,SCREEN_HEIGHT-100);
	
	SetVelocity(0,0);
	
	SetID(0);
}

CPlayer::~CPlayer(void)
{
}
