///////////////////////////
//	File: CSGD_Dispatcher.h
//	Author:	Eric Green
//	Purpose: handles the dpsatching of all events to any listeners.

#pragma once

#include <list>
#include <map>
using std::multimap;
using std::pair;
using std::list;

#include "CEvents.h"
#include "IListener.h"

class CSGD_Dispatcher
{
private:
	// our client list, classes that can listen(Recieve) event information.
	multimap<EVENTID,IListener*>	m_Clients;

	//events waiting to be processed.
	list<CEvent>					m_Events;

	//DispatchEvent : sends an event to all the clients that are registered to reviece event ifnormation
	void DispatchEvent(CEvent *pEvent);
	static CSGD_Dispatcher* m_pInstance;

public:
	CSGD_Dispatcher(){}
	~CSGD_Dispatcher(){}
	static CSGD_Dispatcher* GetInstance();

	void UnregisterClient(IListener *pClient);

	//regusters a client to recieve events from the dispatcher
	void RegisterClient(EVENTID eventID, IListener *pClient);

	//sends an event to the dispatcher to be processed
	void SendEvent(EVENTID eventID, void *pParam = 0);

	// process all the events
	void ProcessEvents();

};