///////////////////////////////
//File:CSGD_MemoryManager.h
//Author:Eric Green
//Purpose:keeps track of and manage all game memory.

#pragma once

class CSGD_MemoryManager
{
private:
	struct tMemoryNode
	{
		void	*pMemory;		//Where the memory gets stored.
		size_t		nSize;			//size of the memory. in Bytes.

		int		nLine;			//line of code where the memory gets allocated.
		char	szFile[128];	// what file the memory got allocated in.

		tMemoryNode *pNext;		// pointer to the next node (memory block).

	};

	size_t		m_nCurUsedMem;	// current amount of memory being used.
	size_t		m_nMaxUsedMem;	// Total amount of memory used throughout the length of the application.

	tMemoryNode *m_pMemoryHead; // Start of my linked list

	static CSGD_MemoryManager	m_Instance;

	CSGD_MemoryManager();
	CSGD_MemoryManager(CSGD_MemoryManager &ref);
	CSGD_MemoryManager &operator = (CSGD_MemoryManager &ref);

	

public:
	~CSGD_MemoryManager();

	//get instance
	static CSGD_MemoryManager *GetInstance();

#ifdef _DEBUG

	friend void *operator new(size_t nBytes, int nLine, char *szFile);

	friend void operator delete(void *pMem);

	friend void operator delete[](void *pMem);


#endif
	//logs out information about the memory manager.
	void LogStatus();

	//flushes all memory from use
	void Flush();

	// shutsdown the memory manager.
	void Shutdown();
};

#ifdef _DEBUG

#define new new(__LINE__,__FILE__)


#endif