///////////////////////////
//	File: CSGD_MessageSystem.cpp
//	Author:	Eric Green
//	Purpose: Message System function definitions


#include "CSGD_MessageSystem.h"

CSGD_MessageSystem* CSGD_MessageSystem::m_pInstance;

CSGD_MessageSystem* CSGD_MessageSystem::GetInstance()
{
	if(!m_pInstance)
		m_pInstance = new CSGD_MessageSystem;
	return m_pInstance;
}

void CSGD_MessageSystem::SetMsgProc(MESSAGEPROC msgProc)
{
	if (!msgProc) return;

	m_MsgProc = msgProc;
}

void CSGD_MessageSystem::SendMsg(CBaseMessage *pMsg)
{
	//make sure the message eixists.
	if(!pMsg) return;

	m_MsgQueue.push(pMsg);
}

void CSGD_MessageSystem::PostMsg(CBaseMessage *pMsg)
{
	// make sure msg exists.
	if(!pMsg) return;

	//make sure msgproc exists.
	if(!m_MsgProc) return;

	//send the message directly to the message proc for processing
	m_MsgProc(pMsg);

	delete pMsg;
}

void CSGD_MessageSystem::ProcessMessages()
{
	if(!m_MsgProc) return;

	//go through all of our message sin the queue and send
	//them to our proc to be processed.
	while(!m_MsgQueue.empty())
	{
		m_MsgProc(m_MsgQueue.front());
		delete m_MsgQueue.front();
		m_MsgQueue.pop();
	}
}