// CSGD_MessageSystem.h:handles all the messages for my application.

#pragma once
#include "CMessages.h"

typedef void (*MESSAGEPROC)(CBaseMessage*);

class CSGD_MessageSystem
{
private:
	MESSAGEPROC				m_MsgProc;	//pointer to the mesaage proc function
	queue<CBaseMessage*>	m_MsgQueue; //where we store all of our messages
	static CSGD_MessageSystem	*m_pInstance;
public:
	CSGD_MessageSystem() { m_MsgProc = 0; }
	~CSGD_MessageSystem() {}

	static CSGD_MessageSystem* GetInstance();
	//set the message proc function for our message system.
	void SetMsgProc(MESSAGEPROC msgProc);

	//sends a message to be added to the queue.
	void SendMsg(CBaseMessage *pMsg);

	// processes a message immeediatly
	void PostMsg(CBaseMessage *pMsg);

	//process all the messages in the queue. only called one time per frame.
	void ProcessMessages();
};