///////////////////////////////
//File:CSGD_ObjectManager.h
//Author:Eric Green
//Purpose:Contains the Object Manager class which handles all game objects.
#pragma once
#include <vector>
#include <map>
#include <string>
#include "CBullet.h"
using std::vector;
using std::map;
using std::string;

#include "CBase.h"

#ifndef SAFE_RELEASE
#define SAFE_RELEASE(p) if(p) { p->Release(); p = 0; }
#endif

class CSGD_ObjectManager
{
private:
	static CSGD_ObjectManager * m_pInstance;
	//a vactor fo all the objecst being managed by the object manager.
	vector<CBase*>			m_vObjects;
	//registry
	map<string, CBase *>	m_Registry;
	CSGD_ObjectManager(void);

	CBullet* m_pBullet;
	CSGD_ObjectManager(const CSGD_ObjectManager &ref){}
	CSGD_ObjectManager operator=(const CSGD_ObjectManager &ref){}

public:
	
	virtual ~CSGD_ObjectManager(void);

	static CSGD_ObjectManager* GetInstance();

	//addobject-thisaddsanobjecttotheobjectmanageraswellastheregistryforfastersearches.
	void AddObject(string strID, CBase *pObj);

	//removeobject-thisremovesanobjectfromtheobjectmanagerthisalsounregisterstheobject.
	void RemoveObject(string strID, CBase *pObj);

	//removesandunregistersalltheobjectsinthemanager
	void RemoveAllObjects();

	//updateallobjects
	void UpdateObjects();

	//renerallobjects
	void RenderObjects();

	//findgivenobject
	CBase* FindObect(string strID);

	void CheckCollisions();


};
