///////////////////////////
//	File: CWorld.cpp
//	Author:	Eric Green
//	Purpose: CWorld class function definitions
#include "CWorld.h"
#include "CSGD_WaveManager.h"
#include "ErG_DirectShow.h"
#include <windows.h>
//#include "WIN32.h"

CWorld CWorld::m_Instance;
CWorld::CWorld(void)
{
	

	m_nFire_Sound = 0;
	m_nEnemyFire_Sound = 0;
	m_nPlayerHit_Sound = 0;
	m_nEnemyHit_Sound = 0;
	m_nShieldHit_Sound = 0;
	m_nVictory_Sound = 0;
	m_nGameOver_Sound = 0;
	m_nGameMusic_BG_Sound = 0;


	m_nBGMPTHREE = 0;
	m_nMenu_BG_Sound = 0;
	m_nMenuMove_Sound = 0;
	m_nMenuSelect_Sound = 0;

	m_nEnemyDirection = 3;
	m_nEnemyYPos = 0;
	m_bMenuState = 1;
	m_nMenuSelection = 0;
	m_nLastEndCondition = CWorld::eEnd::END_NONE;
	m_nDifficulty = 1;


}

CWorld::~CWorld(void)
{
}



CWorld* CWorld::GetInstance()
{
	return &m_Instance;
}

void CWorld::Init()
{
	CSGD_WaveManager* m_pWM = CSGD_WaveManager::GetInstance();

	m_nFire_Sound = m_pWM->LoadWave("SGD_Laser1.wav");
	m_nEnemyFire_Sound = m_pWM->LoadWave("SGD_EnemyFire.wav");
	m_nPlayerHit_Sound = m_pWM->LoadWave("SGD_PlayerHit.wav");
	m_nEnemyHit_Sound = m_pWM->LoadWave("SGD_Hit.wav");
	m_nShieldHit_Sound = m_pWM->LoadWave("SGD_ShieldHit.wav");
	m_nVictory_Sound = m_pWM->LoadWave("SGD_Win.wav");
	m_nGameOver_Sound = m_pWM->LoadWave("SGD_Lose.wav");
	m_nGameMusic_BG_Sound = m_pWM->LoadWave("SGD_BG_Music1.wav");

	m_nMenu_BG_Sound = m_pWM->LoadWave("SGD_Laser1.wav");	
	m_nMenuMove_Sound = m_pWM->LoadWave("SGD_MenuMove.wav");
	m_nMenuSelect_Sound = m_pWM->LoadWave("SGD_MenuSelect.wav");
	m_nBossShot_Sound = m_pWM->LoadWave("ErG_HomingShot.wav");
	m_nPickup_Sound = m_pWM->LoadWave("ErG_Pickup.wav");

	//LPCWSTR buffer;
	//wsprintf(buffer,_T());
	m_nBGMPTHREE = ErG_DirectShow::GetInstance()->Load("08-hans_zimmer-parlay.mp3");
}

//ACCESSORS
int CWorld::GetShotSound()
{
	return m_nFire_Sound;
}

int CWorld::GetEShotSound()
{
	return m_nEnemyFire_Sound;
}
int CWorld::GetPlayerHitSound()
{
	return m_nPlayerHit_Sound;
}
int CWorld::GetEnemyHitSound()
{
	return m_nEnemyHit_Sound;
}
int CWorld::GetShieldHitSound()
{
	return m_nShieldHit_Sound;
}
int CWorld::GetVictorySound()
{
	return m_nVictory_Sound;
}
int CWorld::GetGameOverSound()
{
	return m_nGameOver_Sound;
}
int CWorld::GetGameMusic()
{
	return m_nGameMusic_BG_Sound;
}

int CWorld::GetBossShoutSound()
{
	return m_nBossShot_Sound;
}

int CWorld::GetPickupSound()
{
	return m_nPickup_Sound;
}



int CWorld::GetMenuMusic()
{
	return m_nMenu_BG_Sound;
}
int CWorld::GetMenuMoveSound()
{
	return m_nMenuMove_Sound;
}
int CWorld::GetMenuSelectSound()
{
	return m_nMenuSelect_Sound;
}

int CWorld::GetEnemyDirection()
{
	return m_nEnemyDirection;
}

int CWorld::GetEnemyYPos()
{
	return m_nEnemyYPos;
}

int CWorld::GetMenuState()
{
	return m_bMenuState;
}

int CWorld::GetMenuSelection()
{
	return m_nMenuSelection;
}
int CWorld::GetEndCondition()
{
	return m_nLastEndCondition;
}

int CWorld::GetEnemyCount()
{
	return m_nEnemyCount;
}

int CWorld::GetScore()
{
	return m_nScore;
}

int CWorld::GetMPTHREE()
{
	return m_nBGMPTHREE;
}

int CWorld::GetHighScores(int index)
{
	return m_nHighScore[index];
}

string CWorld::GetHSName(int index)
{
	return m_szHighScoreNames[index];
}

int CWorld::GetDifficulty()
{
	return m_nDifficulty;
}

int CWorld::GetWeaponLevel()
{
	return m_nWeaponLevel;
}

int CWorld::GetLevel()
{
	return m_nGameLevel;
}

int CWorld::GetLives()
{
	return m_nLives;
}

DWORD CWorld::GetTime()
{
	return m_dwTime;
}

bool CWorld::GetGodMode()
{
	return m_bGodMode;
}

bool CWorld::GetBossExplode()
{
	return m_bBossExplode;
}

bool CWorld::GetPlayerSmoke()
{
	return m_bPlayerSmoke;
}

//MODIFIERS
void CWorld::SetEnemyDirection(int val)
{
	m_nEnemyDirection = val;
}

void CWorld::SetEnemyYPos(int val)
{
	m_nEnemyYPos = val;
}

void CWorld::SetMenuState(int val)
{
	m_bMenuState = val;
}

void CWorld::SetMenuSelection(int val)
{
	m_nMenuSelection = val;
}

void CWorld::SetEndCondition(int val)
{
	m_nLastEndCondition = val;
}

void CWorld::SetEnemyCount(int val)
{
	m_nEnemyCount = val;
}

void CWorld::SetScore(int val)
{
	m_nScore = val;
}
void CWorld::SetHighScore(int val, int index, string szName)
{
	m_nHighScore[index] = val;
	m_szHighScoreNames[index] = szName;
}

void CWorld::SetDifficulty(int val)
{
	m_nDifficulty = val;
}

void CWorld::SetWeaponLevel(int val)
{
	m_nWeaponLevel = val;
}

void CWorld::SetLevel(int val)
{
	m_nGameLevel = val;
}

void CWorld::SetLives(int val)
{
	m_nLives = val;
}

void CWorld::SetTime(DWORD val)
{
	m_dwTime = val;
}

void CWorld::SetBossExplode(bool val)
{
	m_bBossExplode = val;
}

void CWorld::SetPlayerSmoke(bool val)
{
	m_bPlayerSmoke;
}

void CWorld::Cheetz_Life()
{
	m_nLives++;
}
void CWorld::Cheetz_God()
{
	m_bGodMode = true;
}
void CWorld::Cheetz_Weapon()
{
	m_nWeaponLevel = 4;
}

