///////////////////////////
//	File: CWorld.h
//	Author:	Eric Green
//	Purpose: Contains CWorld Singleton Class definition
#pragma once
#include <windows.h>
#include <vector>
#include <string>
#pragma warning (disable:4482)
using std::vector;
using std::string;

class CWorld
{
private:
	static CWorld m_Instance;			//	The Instance of this class.

	int m_nFire_Sound;
	int m_nEnemyFire_Sound;
	int m_nPlayerHit_Sound;
	int m_nEnemyHit_Sound;
	int	m_nShieldHit_Sound;
	int m_nVictory_Sound;
	int m_nGameOver_Sound;
	int m_nGameMusic_BG_Sound;
	int m_nBossShot_Sound;
	int m_nPickup_Sound;

	int m_nBGMPTHREE;

	int	m_nMenu_BG_Sound;	
	int m_nMenuMove_Sound;
	int m_nMenuSelect_Sound;

	int m_nEnemyDirection;
	int m_nEnemyYPos;
	int m_bMenuState;
	int m_nMenuSelection;
	int m_nLastEndCondition;
	int m_nEnemyCount;
	int m_nScore;

	int m_nDifficulty;
	int m_nWeaponLevel;
	int m_nGameLevel;
	int m_nLives;

	bool m_bBossExplode;
	bool m_bPlayerSmoke;

	RECT m_nViewOne;
	RECT m_nViewTwo;
	RECT m_nViewThree;

	vector<string> m_szHighScoreNames;
	int m_nHighScore[10];
	DWORD m_dwTime;

	bool m_bGodMode;
public:

	CWorld(void);
	virtual ~CWorld(void);
	
	enum eEnd{END_NONE=0,END_WIN,END_LOSE};
	enum eMenu{SELECT_PLAY=0,SELECT_EXIT, SELECT_EASY, SELECT_MEDIUM, SELECT_HARD, SELECT_RESUME};
	enum eMState{MENU_OFF=0, MENU_ON, MENU_DIFFICULTY, MENU_INGAME};
	enum eGAME_MESSAGES { eGM_COLLISION = 0, eGM_MOVE, eGM_PLAYER_FIRE, eGM_ENEMY_FIRE, eGM_KILL_BULLET, eGM_CREATE_ENEMY,
		eGM_CREATE_MINIBOSS, eGM_CREATE_BOSS, eGM_MBOSS_FIRE, eGM_BOSS_FIRE, eGM_MISSLE_FIRE, eGM_DROP_PICKUP};
	enum eDirections { eDIR_LEFT = 0, eDIR_RIGHT, eDIR_UP, eDIR_DOWN, eDIR_STOP};

	static CWorld* GetInstance();

	///////
	//Function:Init
	//Purpose:to set all sound files up for use
	void Init();
	//////
	//Function:accessors
	//Purpose:to access the specified type
	int GetShotSound();
	int GetEShotSound();
	int GetPlayerHitSound();
	int GetEnemyHitSound();
	int GetShieldHitSound();
	int GetVictorySound();
	int GetGameOverSound();
	int GetGameMusic();
	int GetBossShoutSound();
	int GetPickupSound();
	int GetEnemyCount();
	

	int GetMPTHREE();

	int GetMenuMusic();
	int GetMenuMoveSound();
	int GetMenuSelectSound();

	int GetEnemyDirection();
	int GetEnemyYPos();
	int GetMenuState();
	int GetMenuSelection();
	int GetEndCondition();
	int GetScore();
	int GetHighScores(int index);
	string GetHSName(int index);
	int GetDifficulty();
	int GetWeaponLevel();
	int GetLevel();
	int GetLives();
	DWORD GetTime();
	bool GetGodMode();
	bool GetBossExplode();
	bool GetPlayerSmoke();


	///////
	//Function:modifiers
	//purpose:To modify the specified type...
	//NotProvidedForSounds. These items should not be modified via game code.
	//Music is hard coded and provided via singleton class for global use.
	void SetEnemyDirection(int val);
	void SetEnemyYPos(int val);
	void SetMenuState(int val);
	void SetMenuSelection(int val);
	void SetEndCondition(int val);
	void SetEnemyCount(int val);
	void SetScore(int val);
	void SetHighScore(int val, int index, string szName);
	void SetDifficulty(int val);
	void SetWeaponLevel(int val);
	void SetLevel(int val);
	void SetLives(int val);
	void SetTime(DWORD val);
	void SetBossExplode(bool val);
	void SetPlayerSmoke(bool val);

	///////
	//Functions:Cheatz_Type
	//purpose: to hax...
	void Cheetz_Life();
	void Cheetz_Health();
	void Cheetz_God();
	void Cheetz_Weapon();
	


};
