///////
//File:ErG_DirectShow.h
//Purpose: Contains Direct Show Wrapper
#pragma once
#pragma comment(lib, "strmiids.lib")
#include <windows.h>                       // Needed for Windows.
#include <dshow.h>                         // Needed for DirectShow.
#include <vector>
//#include "WIN32.h"
using std::vector;


#define WM_GRAPHNOTIFY     WM_APP + 1      // Message Handler case.

// Convert from Decibel Level to Logarithmic Scale.

#define DECTOLOG(vol)      (-15 * (100 - vol))

// Convert to scale of (-10,000, 10,000).

#define CONVPAN(pan)        (pan * 100)

class ErG_DirectShow
{
private:


	struct tFile
	{
		char szName[_MAX_PATH];
		int ref;

		tFile()
		{
			szName[0] = '\0';
			ref = 0;
		}
	};


	IBasicAudio   *pBasicAudio;

	IMediaSeeking *pMediaSeeking; 

	IGraphBuilder *pGraphBuilder;    // The Filter Graph Manager.

	IMediaControl *pMediaControl;    // Control the Movie.

	IVideoWindow  *pVideoWindow;    // Where the Movie is gonna play.

	IMediaEventEx *pMediaEvent;    // Handle Movie Events.

	HWND hWnd;

	vector<tFile> m_vFiles;
	static ErG_DirectShow m_pInstance;
	ErG_DirectShow();
	ErG_DirectShow(const ErG_DirectShow &ref){}
	ErG_DirectShow &operator =(const ErG_DirectShow &ref){}

public:
	virtual ~ErG_DirectShow(){}
	static ErG_DirectShow* GetInstance();
	void Init(HWND hWnd);
	int Load(char* szFilename);
	void Play(int nID, DWORD dwFlags = 0);
	void Restart();
	void SetVolume(int volume);
	void SetPan(int pan);
	void HandleEvent();
	void Shutdown();

};