///////////////////////////
//	File: IBaseInterface.h
//	Author:	Eric Green
//	Purpose: the blueprint class for all of my derived classes. Has Smart Pointer Functionality.

#pragma once

class IBaseInterface
{
protected:
	unsigned int m_unRefCount;		//the reference counter keeps track of how 
									//many pointers are pointing to this memory.
public:
	
	IBaseInterface() { m_unRefCount = 1; }
	virtual ~IBaseInterface() {}

	//Blueprint Functions for smart pointer interface.

	virtual void AddRef() = 0;
	virtual void Release() = 0;

	//blueprint functions for my derived classes.
	virtual void Update() = 0;
	virtual void Render() = 0;
};