// SGD_Math.cpp

#include "SGD_Math.h"
#include <math.h>
#include <float.h>

double Vector2DLength(tVector2D vector)
{
	return sqrt((vector.dX * vector.dX) + (vector.dY * vector.dY));
}

//normalize a vector
tVector2D Vector2DNormalize(tVector2D vector)
{
	tVector2D vctNormalized;
	double dLength = Vector2DLength(vector);
	vctNormalized.dX = vector.dX / dLength;
	vctNormalized.dY = vector.dY / dLength;

	//return the normalized vector.
	return vctNormalized;
}

tVector2D Vector2DRotate(tVector2D vector, double dRadians)
{
	vector.dY *= -1;
	tVector2D vctRotated;
	vctRotated.dX = ( cos(dRadians) * vector.dX) + (sin(dRadians) * vector.dY);
	vctRotated.dY = ( -sin(dRadians) * vector.dX) + (cos(dRadians) * vector.dY);

	vctRotated.dY *= -1;

	return vctRotated;
}

double AngleBetweenVectors(tVector2D &v1, tVector2D &v2)
{
	double dDot = (v1.dX * v2.dX) + (v1.dY * v2.dY);

	double dMag = Vector2DLength(v1) * Vector2DLength(v2);

	double dAngle = acos(dDot/dMag);
	if(_isnan(dAngle))
		return 0;

	return dAngle;
}